/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.biome.v1.OverworldBiomes;
import net.fabricmc.fabric.impl.biome.InternalBiomeData;
import net.fabricmc.fabric.impl.biome.InternalBiomeUtils;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.minecraft.class_1959;
import net.minecraft.class_3625;
import net.minecraft.class_3630;
import net.minecraft.class_3645;
import net.minecraft.class_3648;
import net.minecraft.class_5321;
import net.minecraft.class_5504;

/**
 * Injects hills biomes specified from {@link OverworldBiomes#addHillsBiome(class_5321, class_5321, double)} into the default hills layer.
 */
@Mixin(class_3648.class)
public class MixinAddHillsLayer {
	// This maps between from a biome to it's "modified variant" biome, which was previously modeled via parent biomes
	@Shadow
	private static Int2IntMap field_26727;

	@Inject(at = @At("HEAD"), method = "sample", cancellable = true)
	private void sample(class_3630 rand, class_3625 biomeSampler, class_3625 noiseSampler, int chunkX, int chunkZ, CallbackInfoReturnable<Integer> info) {
		if (InternalBiomeData.getOverworldHills().isEmpty()) {
			// No use doing anything if there are no hills registered. Fall through to vanilla logic.
			return;
		}

		final int biomeId = biomeSampler.method_15825(chunkX, chunkZ);
		int noiseSample = noiseSampler.method_15825(chunkX, chunkZ);
		int processedNoiseSample = (noiseSample - 2) % 29;
		class_5321<class_1959> key = class_5504.method_31144(biomeId);

		if (key == null) {
			throw new IllegalStateException("Biome sampler returned unregistered Biome ID: " + biomeId);
		}

		WeightedBiomePicker hillPicker = InternalBiomeData.getOverworldHills().get(key);

		if (hillPicker == null) {
			// No hills for this biome, fall through to vanilla logic.

			return;
		}

		if (rand.method_15834(3) == 0 || processedNoiseSample == 0) {
			int biomeReturn = InternalBiomeUtils.getRawId(hillPicker.pickRandom(rand));

			if (processedNoiseSample == 0 && biomeReturn != biomeId) {
				biomeReturn = field_26727.getOrDefault(biomeReturn, biomeId);
			}

			if (biomeReturn != biomeId) {
				int similarity = 0;

				if (class_3645.method_15844(biomeSampler.method_15825(chunkX, chunkZ - 1), biomeId)) {
					++similarity;
				}

				if (class_3645.method_15844(biomeSampler.method_15825(chunkX + 1, chunkZ), biomeId)) {
					++similarity;
				}

				if (class_3645.method_15844(biomeSampler.method_15825(chunkX - 1, chunkZ), biomeId)) {
					++similarity;
				}

				if (class_3645.method_15844(biomeSampler.method_15825(chunkX, chunkZ + 1), biomeId)) {
					++similarity;
				}

				if (similarity >= 3) {
					info.setReturnValue(biomeReturn);
					return;
				}
			}
		}

		// Cancel vanilla logic.
		info.setReturnValue(biomeId);
	}
}
