/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.biome.InternalBiomeData;
import net.fabricmc.fabric.impl.biome.SimpleLayerRandomnessSource;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_3630;
import net.minecraft.class_5321;

@Mixin(class_2169.class)
public class MixinTheEndBiomeSource {
	@Shadow
	@Final
	private class_2378<class_1959> biomeRegistry;
	@Shadow
	@Final
	private long seed;
	@Unique
	private class_3630 randomnessSource = new SimpleLayerRandomnessSource(seed);

	@Inject(method = "getBiomeForNoiseGen", at = @At("RETURN"), cancellable = true)
	private void getWeightedEndBiome(int biomeX, int biomeY, int biomeZ, CallbackInfoReturnable<class_1959> cir) {
		class_1959 vanillaBiome = cir.getReturnValue();

		// Since all vanilla biomes are added to the registry, this will never fail.
		class_5321<class_1959> vanillaKey = biomeRegistry.method_29113(vanillaBiome).get();
		class_5321<class_1959> replacementKey;

		// The x and z of the biome are divided by 64 to ensure custom biomes are large enough; going larger than this]
		// seems to make custom biomes too hard to find.
		if (vanillaKey == class_1972.field_9447 || vanillaKey == class_1972.field_9465) {
			// Since the highlands picker is statically populated by InternalBiomeData, picker will never be null.
			WeightedBiomePicker highlandsPicker = InternalBiomeData.getEndBiomesMap().get(class_1972.field_9442);
			class_5321<class_1959> highlandsKey = highlandsPicker.pickFromNoise(randomnessSource, biomeX/64.0, 0, biomeZ/64.0);

			if (vanillaKey == class_1972.field_9447) {
				WeightedBiomePicker midlandsPicker = InternalBiomeData.getEndMidlandsMap().get(highlandsKey);
				replacementKey = (midlandsPicker == null) ? vanillaKey : midlandsPicker.pickFromNoise(randomnessSource, biomeX/64.0, 0, biomeZ/64.0);
			} else {
				WeightedBiomePicker barrensPicker = InternalBiomeData.getEndBarrensMap().get(highlandsKey);
				replacementKey = (barrensPicker == null) ? vanillaKey : barrensPicker.pickFromNoise(randomnessSource, biomeX/64.0, 0, biomeZ/64.0);
			}
		} else {
			// Since the main island and small islands pickers are statically populated by InternalBiomeData, picker will never be null.
			WeightedBiomePicker picker = InternalBiomeData.getEndBiomesMap().get(vanillaKey);
			replacementKey = picker.pickFromNoise(randomnessSource, biomeX/64.0, 0, biomeZ/64.0);
		}

		cir.setReturnValue(biomeRegistry.method_29107(replacementKey));
	}
}
