/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome.modification;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.mixin.biome.modification.BiomeAccessor;
import net.fabricmc.fabric.mixin.biome.modification.BiomeEffectsAccessor;
import net.fabricmc.fabric.mixin.biome.modification.BiomeWeatherAccessor;
import net.fabricmc.fabric.mixin.biome.modification.GenerationSettingsAccessor;
import net.fabricmc.fabric.mixin.biome.modification.SpawnDensityAccessor;
import net.fabricmc.fabric.mixin.biome.modification.SpawnSettingsAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3195;
import net.minecraft.class_3414;
import net.minecraft.class_3504;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class BiomeModificationContextImpl
implements BiomeModificationContext {
    private final class_5455 registries;
    private final class_1959 biome;
    private final BiomeAccessor biomeAccessor;
    private final BiomeModificationContext.WeatherContext weather;
    private final BiomeModificationContext.EffectsContext effects;
    private final GenerationSettingsContextImpl generationSettings;
    private final SpawnSettingsContextImpl spawnSettings;

    public BiomeModificationContextImpl(class_5455 registries, class_1959 biome) {
        this.registries = registries;
        this.biome = biome;
        this.biomeAccessor = (BiomeAccessor)biome;
        this.weather = new WeatherContextImpl();
        this.effects = new EffectsContextImpl();
        this.generationSettings = new GenerationSettingsContextImpl();
        this.spawnSettings = new SpawnSettingsContextImpl();
    }

    @Override
    public void setDepth(float depth) {
        this.biomeAccessor.fabric_setDepth(depth);
    }

    @Override
    public void setScale(float scale) {
        this.biomeAccessor.fabric_setScale(scale);
    }

    @Override
    public void setCategory(class_1959.class_1961 category) {
        this.biomeAccessor.fabric_setCategory(category);
    }

    @Override
    public BiomeModificationContext.WeatherContext getWeather() {
        return this.weather;
    }

    @Override
    public BiomeModificationContext.EffectsContext getEffects() {
        return this.effects;
    }

    @Override
    public BiomeModificationContext.GenerationSettingsContext getGenerationSettings() {
        return this.generationSettings;
    }

    @Override
    public BiomeModificationContext.SpawnSettingsContext getSpawnSettings() {
        return this.spawnSettings;
    }

    void freeze() {
        this.generationSettings.freeze();
        this.spawnSettings.freeze();
    }

    private class WeatherContextImpl
    implements BiomeModificationContext.WeatherContext {
        private final BiomeWeatherAccessor accessor;

        private WeatherContextImpl() {
            this.accessor = (BiomeWeatherAccessor)BiomeModificationContextImpl.this.biomeAccessor.fabric_getWeather();
        }

        @Override
        public void setPrecipitation(class_1959.class_1963 precipitation) {
            Objects.requireNonNull(precipitation);
            this.accessor.setPrecipitation(precipitation);
        }

        @Override
        public void setTemperature(float temperature) {
            this.accessor.setTemperature(temperature);
        }

        @Override
        public void setTemperatureModifier(class_1959.class_5484 temperatureModifier) {
            Objects.requireNonNull(temperatureModifier);
            this.accessor.setTemperatureModifier(temperatureModifier);
        }

        @Override
        public void setDownfall(float downfall) {
            this.accessor.setDownfall(downfall);
        }
    }

    private class EffectsContextImpl
    implements BiomeModificationContext.EffectsContext {
        private final BiomeEffectsAccessor accessor;

        private EffectsContextImpl() {
            this.accessor = (BiomeEffectsAccessor)BiomeModificationContextImpl.this.biome.method_24377();
        }

        @Override
        public void setFogColor(int color) {
            this.accessor.fabric_setFogColor(color);
        }

        @Override
        public void setWaterColor(int color) {
            this.accessor.fabric_setWaterColor(color);
        }

        @Override
        public void setWaterFogColor(int color) {
            this.accessor.fabric_setWaterFogColor(color);
        }

        @Override
        public void setSkyColor(int color) {
            this.accessor.fabric_setSkyColor(color);
        }

        @Override
        public void setFoliageColor(Optional<Integer> color) {
            Objects.requireNonNull(color);
            this.accessor.fabric_setFoliageColor(color);
        }

        @Override
        public void setGrassColor(Optional<Integer> color) {
            Objects.requireNonNull(color);
            this.accessor.fabric_setGrassColor(color);
        }

        @Override
        public void setGrassColorModifier(@NotNull class_4763.class_5486 colorModifier) {
            Objects.requireNonNull(colorModifier);
            this.accessor.fabric_setGrassColorModifier(colorModifier);
        }

        @Override
        public void setParticleConfig(Optional<class_4761> particleConfig) {
            Objects.requireNonNull(particleConfig);
            this.accessor.fabric_setParticleConfig(particleConfig);
        }

        @Override
        public void setAmbientSound(Optional<class_3414> sound) {
            Objects.requireNonNull(sound);
            this.accessor.fabric_setLoopSound(sound);
        }

        @Override
        public void setMoodSound(Optional<class_4968> sound) {
            Objects.requireNonNull(sound);
            this.accessor.fabric_setMoodSound(sound);
        }

        @Override
        public void setAdditionsSound(Optional<class_4967> sound) {
            Objects.requireNonNull(sound);
            this.accessor.fabric_setAdditionsSound(sound);
        }

        @Override
        public void setMusic(Optional<class_5195> sound) {
            Objects.requireNonNull(sound);
            this.accessor.fabric_setMusic(sound);
        }
    }

    private class GenerationSettingsContextImpl
    implements BiomeModificationContext.GenerationSettingsContext {
        private final class_2378<class_2922<?>> carvers;
        private final class_2378<class_2975<?, ?>> features;
        private final class_2378<class_5312<?, ?>> structures;
        private final class_2378<class_3504<?>> surfaceBuilders;
        private final class_5485 generationSettings;
        private final GenerationSettingsAccessor accessor;

        GenerationSettingsContextImpl() {
            this.carvers = BiomeModificationContextImpl.this.registries.method_30530(class_2378.field_25913);
            this.features = BiomeModificationContextImpl.this.registries.method_30530(class_2378.field_25914);
            this.structures = BiomeModificationContextImpl.this.registries.method_30530(class_2378.field_25915);
            this.surfaceBuilders = BiomeModificationContextImpl.this.registries.method_30530(class_2378.field_25912);
            this.generationSettings = BiomeModificationContextImpl.this.biome.method_30970();
            this.accessor = (GenerationSettingsAccessor)this.generationSettings;
            this.unfreezeCarvers();
            this.unfreezeFeatures();
            this.unfreezeFlowerFeatures();
            this.unfreezeStructures();
        }

        private void unfreezeCarvers() {
            EnumMap carversByStep = new EnumMap(class_2893.class_2894.class);
            carversByStep.putAll(this.accessor.fabric_getCarvers());
            for (class_2893.class_2894 step : class_2893.class_2894.values()) {
                ArrayList carvers = (ArrayList)carversByStep.get(step);
                carvers = carvers == null ? new ArrayList() : new ArrayList(carvers);
                carversByStep.put(step, carvers);
            }
            this.accessor.fabric_setCarvers(carversByStep);
        }

        private void unfreezeFeatures() {
            List<List<Supplier<class_2975<?, ?>>>> features = this.accessor.fabric_getFeatures();
            features = new ArrayList(features);
            for (int i = 0; i < features.size(); ++i) {
                features.set(i, new ArrayList(features.get(i)));
            }
            this.accessor.fabric_setFeatures(features);
        }

        private void unfreezeFlowerFeatures() {
            this.accessor.fabric_setFlowerFeatures(new ArrayList(this.accessor.fabric_getFlowerFeatures()));
        }

        private void unfreezeStructures() {
            this.accessor.fabric_setStructureFeatures(new ArrayList(this.accessor.fabric_getStructureFeatures()));
        }

        public void freeze() {
            this.freezeCarvers();
            this.freezeFeatures();
            this.freezeFlowerFeatures();
            this.freezeStructures();
        }

        private void freezeCarvers() {
            Map<class_2893.class_2894, List<Supplier<class_2922<?>>>> carversByStep = this.accessor.fabric_getCarvers();
            for (class_2893.class_2894 step : class_2893.class_2894.values()) {
                carversByStep.put(step, (List<Supplier<class_2922<?>>>)ImmutableList.copyOf((Collection)carversByStep.get(step)));
            }
            this.accessor.fabric_setCarvers((Map<class_2893.class_2894, List<Supplier<class_2922<?>>>>)ImmutableMap.copyOf(carversByStep));
        }

        private void freezeFeatures() {
            List<List<Supplier<class_2975<?, ?>>>> featureSteps = this.accessor.fabric_getFeatures();
            for (int i = 0; i < featureSteps.size(); ++i) {
                featureSteps.set(i, (List<Supplier<class_2975<?, ?>>>)ImmutableList.copyOf((Collection)featureSteps.get(i)));
            }
            this.accessor.fabric_setFeatures((List<List<Supplier<class_2975<?, ?>>>>)ImmutableList.copyOf(featureSteps));
        }

        private void freezeFlowerFeatures() {
            this.accessor.fabric_setFlowerFeatures((List<class_2975<?, ?>>)ImmutableList.copyOf(this.accessor.fabric_getFlowerFeatures()));
        }

        private void freezeStructures() {
            this.accessor.fabric_setStructureFeatures((List<Supplier<class_5312<?, ?>>>)ImmutableList.copyOf(this.accessor.fabric_getStructureFeatures()));
        }

        @Override
        public void setSurfaceBuilder(class_5321<class_3504<?>> surfaceBuilderKey) {
            class_3504 surfaceBuilder = (class_3504)this.surfaceBuilders.method_31140(surfaceBuilderKey);
            this.accessor.fabric_setSurfaceBuilder(() -> surfaceBuilder);
        }

        @Override
        public boolean removeFeature(class_2893.class_2895 step, class_5321<class_2975<?, ?>> configuredFeatureKey) {
            List<List<Supplier<class_2975<?, ?>>>> featureSteps;
            class_2975 configuredFeature = (class_2975)this.features.method_31140(configuredFeatureKey);
            int stepIndex = step.ordinal();
            if (stepIndex >= (featureSteps = this.accessor.fabric_getFeatures()).size()) {
                return false;
            }
            List<Supplier<class_2975<?, ?>>> featuresInStep = featureSteps.get(stepIndex);
            if (featuresInStep.removeIf(supplier -> supplier.get() == configuredFeature)) {
                this.rebuildFlowerFeatures();
                return true;
            }
            return false;
        }

        @Override
        public void addFeature(class_2893.class_2895 step, class_5321<class_2975<?, ?>> configuredFeatureKey) {
            class_2975 configuredFeature = (class_2975)this.features.method_31140(configuredFeatureKey);
            List<List<Supplier<class_2975<?, ?>>>> featureSteps = this.accessor.fabric_getFeatures();
            int index = step.ordinal();
            while (index >= featureSteps.size()) {
                featureSteps.add(new ArrayList());
            }
            featureSteps.get(index).add(() -> configuredFeature);
            this.rebuildFlowerFeatures();
        }

        @Override
        public void addCarver(class_2893.class_2894 step, class_5321<class_2922<?>> carverKey) {
            class_2922 carver = (class_2922)this.carvers.method_31140(carverKey);
            this.accessor.fabric_getCarvers().get(step).add(() -> carver);
        }

        @Override
        public boolean removeCarver(class_2893.class_2894 step, class_5321<class_2922<?>> configuredCarverKey) {
            class_2922 carver = (class_2922)this.carvers.method_31140(configuredCarverKey);
            return this.accessor.fabric_getCarvers().get(step).removeIf(supplier -> supplier.get() == carver);
        }

        @Override
        public void addStructure(class_5321<class_5312<?, ?>> configuredStructureKey) {
            class_5312 configuredStructure = (class_5312)this.structures.method_31140(configuredStructureKey);
            this.removeStructure(configuredStructure.field_24835);
            this.accessor.fabric_getStructureFeatures().add(() -> configuredStructure);
        }

        @Override
        public boolean removeStructure(class_5321<class_5312<?, ?>> configuredStructureKey) {
            class_5312 structure = (class_5312)this.structures.method_31140(configuredStructureKey);
            return this.accessor.fabric_getStructureFeatures().removeIf(s -> s.get() == structure);
        }

        @Override
        public boolean removeStructure(class_3195<?> structure) {
            return this.accessor.fabric_getStructureFeatures().removeIf(s -> ((class_5312)s.get()).field_24835 == structure);
        }

        private void rebuildFlowerFeatures() {
            List<class_2975<?, ?>> flowerFeatures = this.accessor.fabric_getFlowerFeatures();
            flowerFeatures.clear();
            for (List<Supplier<class_2975<?, ?>>> features : this.accessor.fabric_getFeatures()) {
                for (Supplier<class_2975<?, ?>> supplier : features) {
                    supplier.get().method_30648().filter(configuredFeature -> configuredFeature.field_13376 == class_3031.field_21219).forEachOrdered(flowerFeatures::add);
                }
            }
        }
    }

    private class SpawnSettingsContextImpl
    implements BiomeModificationContext.SpawnSettingsContext {
        private final SpawnSettingsAccessor accessor;

        SpawnSettingsContextImpl() {
            this.accessor = (SpawnSettingsAccessor)BiomeModificationContextImpl.this.biome.method_30966();
            this.unfreezeSpawners();
            this.unfreezeSpawnCost();
        }

        private void unfreezeSpawners() {
            EnumMap<class_1311, List<class_5483.class_1964>> spawners = new EnumMap<class_1311, List<class_5483.class_1964>>(class_1311.class);
            spawners.putAll(this.accessor.fabric_getSpawners());
            for (class_1311 spawnGroup : class_1311.values()) {
                List<class_5483.class_1964> entries = spawners.get(spawnGroup);
                if (entries != null) {
                    spawners.put(spawnGroup, new ArrayList<class_5483.class_1964>(entries));
                    continue;
                }
                spawners.put(spawnGroup, new ArrayList());
            }
            this.accessor.fabric_setSpawners(spawners);
        }

        private void unfreezeSpawnCost() {
            this.accessor.fabric_setSpawnCosts(new HashMap(this.accessor.fabric_getSpawnCosts()));
        }

        public void freeze() {
            this.freezeSpawners();
            this.freezeSpawnCosts();
        }

        private void freezeSpawners() {
            Map<class_1311, List<class_5483.class_1964>> spawners = this.accessor.fabric_getSpawners();
            for (Map.Entry<class_1311, List<class_5483.class_1964>> entry : spawners.entrySet()) {
                entry.setValue((List<class_5483.class_1964>)ImmutableList.copyOf((Collection)entry.getValue()));
            }
            this.accessor.fabric_setSpawners((Map<class_1311, List<class_5483.class_1964>>)ImmutableMap.copyOf(spawners));
        }

        private void freezeSpawnCosts() {
            this.accessor.fabric_setSpawnCosts((Map<class_1299<?>, class_5483.class_5265>)ImmutableMap.copyOf(this.accessor.fabric_getSpawnCosts()));
        }

        @Override
        public void setPlayerSpawnFriendly(boolean playerSpawnFriendly) {
            this.accessor.fabric_setPlayerSpawnFriendly(playerSpawnFriendly);
        }

        @Override
        public void setCreatureSpawnProbability(float probability) {
            this.accessor.fabric_setCreatureSpawnProbability(probability);
        }

        @Override
        public void addSpawn(class_1311 spawnGroup, class_5483.class_1964 spawnEntry) {
            Objects.requireNonNull(spawnGroup);
            Objects.requireNonNull(spawnEntry);
            this.accessor.fabric_getSpawners().get(spawnGroup).add(spawnEntry);
        }

        @Override
        public boolean removeSpawns(BiPredicate<class_1311, class_5483.class_1964> predicate) {
            Map<class_1311, List<class_5483.class_1964>> spawners = this.accessor.fabric_getSpawners();
            boolean anyRemoved = false;
            for (class_1311 group : class_1311.values()) {
                if (!spawners.get(group).removeIf(entry -> predicate.test(group, (class_5483.class_1964)entry))) continue;
                anyRemoved = true;
            }
            return anyRemoved;
        }

        @Override
        public void setSpawnCost(class_1299<?> entityType, double mass, double gravityLimit) {
            Objects.requireNonNull(entityType);
            this.accessor.fabric_getSpawnCosts().put(entityType, SpawnDensityAccessor.create(gravityLimit, mass));
        }

        @Override
        public void clearSpawnCost(class_1299<?> entityType) {
            this.accessor.fabric_getSpawnCosts().remove(entityType);
        }
    }
}

