/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.registry;

import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.fabricmc.fabric.impl.content.registry.VillagerInteractionRegistriesImpl;
import net.fabricmc.fabric.mixin.content.registry.GiveGiftsToHeroTaskAccessor;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

/**
 * Registries for modifying villager interactions that
 * villagers have with the world.
 */
public final class VillagerInteractionRegistries {
	private static final Logger LOGGER = LoggerFactory.getLogger(VillagerInteractionRegistries.class);

	private VillagerInteractionRegistries() {
	}

	/**
	 * Registers an item to be collectable (picked up from item entity)
	 * by any profession villagers.
	 *
	 * @param item the item to register
	 * @deprecated Add items to the {@linkplain net.minecraft.class_3489#field_52383 {@code minecraft:villager_picks_up} item tag} instead.
	 */
	@Deprecated
	public static void registerCollectable(class_1935 item) {
		Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
		VillagerInteractionRegistriesImpl.getCollectableRegistry().add(item.method_8389());
	}

	/**
	 * Registers an item to be used in a composter by farmer villagers.
	 * @param item the item to register
	 */
	public static void registerCompostable(class_1935 item) {
		Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
		VillagerInteractionRegistriesImpl.getCompostableRegistry().add(item.method_8389());
	}

	/**
	 * Registers an item to be edible by villagers.
	 * @param item      the item to register
	 * @param foodValue the amount of breeding power the item has (1 = normal food item, 4 = bread)
	 */
	public static void registerFood(class_1935 item, int foodValue) {
		Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
		Integer oldValue = VillagerInteractionRegistriesImpl.getFoodRegistry().put(item.method_8389(), foodValue);

		if (oldValue != null) {
			LOGGER.info("Overriding previous food value of {}, was: {}, now: {}", item.method_8389().toString(), oldValue, foodValue);
		}
	}

	/**
	 * @deprecated Use {@link #registerGiftLootTable(class_3852, class_5321)} instead.
	 */
	@Deprecated
	public static void registerGiftLootTable(class_3852 profession, class_2960 lootTable) {
		registerGiftLootTable(profession, class_5321.method_29179(class_7924.field_50079, lootTable));
	}

	/**
	 * Registers a hero of the village gifts loot table to a profession.
	 * @param profession the profession to modify
	 * @param lootTable  the loot table to associate with the profession
	 */
	public static void registerGiftLootTable(class_3852 profession, class_5321<class_52> lootTable) {
		Objects.requireNonNull(profession, "Profession cannot be null!");
		Objects.requireNonNull(lootTable, "Loot table identifier cannot be null!");
		class_5321<class_52> oldValue = GiveGiftsToHeroTaskAccessor.fabric_getGifts().put(profession, lootTable);

		if (oldValue != null) {
			LOGGER.info("Overriding previous gift loot table of {} profession, was: {}, now: {}", profession.comp_818(), oldValue, lootTable);
		}
	}
}
