/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_161;
import net.minecraft.class_2405;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class FabricAdvancementProvider
implements class_2405 {
    protected final FabricDataOutput output;
    private final class_7784.class_7489 pathResolver;

    protected FabricAdvancementProvider(FabricDataOutput output) {
        this.output = output;
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39367, "advancements");
    }

    public abstract void generateAdvancement(Consumer<class_161> var1);

    protected Consumer<class_161> withConditions(Consumer<class_161> exporter, ConditionJsonProvider ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return advancement -> {
            FabricDataGenHelper.addConditions(advancement, conditions);
            exporter.accept((class_161)advancement);
        };
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        HashSet identifiers = Sets.newHashSet();
        HashSet advancements = Sets.newHashSet();
        this.generateAdvancement(advancements::add);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (class_161 advancement : advancements) {
            if (!identifiers.add(advancement.method_688())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.method_688());
            }
            JsonObject advancementJson = advancement.method_689().method_698();
            ConditionJsonProvider.write((JsonObject)advancementJson, (ConditionJsonProvider[])FabricDataGenHelper.consumeConditions(advancement));
            futures.add(class_2405.method_10320((class_7403)writer, (JsonElement)advancementJson, (Path)this.getOutputPath(advancement)));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private Path getOutputPath(class_161 advancement) {
        return this.pathResolver.method_44107(advancement.method_688());
    }

    public String method_10321() {
        return "Advancements";
    }
}

