/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.dimension;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_5454;

public final class FabricDimensionInternals {
	/**
	 * The target passed to the last call to {@link FabricDimensions#teleport(class_1297, class_3218, class_5454)}.
	 */
	private static class_5454 currentTarget;

	private FabricDimensionInternals() {
		throw new AssertionError();
	}

	/**
	 * Returns the last target set when a user of the API requested teleportation, or null.
	 */
	public static class_5454 getCustomTarget() {
		return currentTarget;
	}

	@SuppressWarnings("unchecked")
	public static <E extends class_1297> E changeDimension(E teleported, class_3218 dimension, class_5454 target) {
		Preconditions.checkArgument(!teleported.field_6002.field_9236, "Entities can only be teleported on the server side");
		Preconditions.checkArgument(Thread.currentThread() == ((class_3218) teleported.field_6002).method_8503().method_3777(), "Entities must be teleported from the main server thread");

		try {
			currentTarget = target;
			return (E) teleported.method_5731(dimension);
		} finally {
			currentTarget = null;
		}
	}
}
