/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.dimension;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.dimension.FabricDimensionInternals;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_5454;

/**
 * This mixin implements {@link class_1297#method_30329(class_3218)} for modded dimensions, as Vanilla will
 * not return a teleport target for anything but Vanilla dimensions.
 */
@Mixin(class_1297.class)
public class EntityMixin {
	@SuppressWarnings("ConstantConditions")
	@Inject(method = "getTeleportTarget", at = @At("HEAD"), cancellable = true, allow = 1)
	public void getTeleportTarget(class_3218 destination, CallbackInfoReturnable<class_5454> cri) {
		class_1297 self = (class_1297) (Object) this;
		// Check if a destination has been set for the entity currently being teleported
		class_5454 customTarget = FabricDimensionInternals.getCustomTarget();

		if (customTarget != null) {
			cri.setReturnValue(customTarget);
		}
	}
}
