/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.block;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

/**
 * Convenience interface for blocks that want more stack picking context than what
 * {@link class_2248#method_9574(class_4538, class_2338, class_2680)} provides.
 *
 * <p>The hit result is guaranteed to be a {@link class_3965} that did not miss.
 */
public interface BlockPickInteractionAware {
	class_1799 getPickedStack(class_2680 state, class_1922 view, class_2338 pos, class_1657 player, class_239 result);
}
