/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2824;
import net.minecraft.class_3244;
import net.minecraft.class_3966;

@Mixin(targets = "net/minecraft/server/network/ServerPlayNetworkHandler$1")
public abstract class ServerPlayNetworkHandlerMixin implements class_2824.class_5908 {
	@Shadow
	@Final
	class_3244 field_28963;

	@Shadow
	@Final
	class_1297 field_28962;

	@Inject(method = "interactAt(Lnet/minecraft/util/Hand;Lnet/minecraft/util/math/Vec3d;)V", at = @At(value = "HEAD"), cancellable = true)
	public void onPlayerInteractEntity(class_1268 hand, class_243 hitPosition, CallbackInfo info) {
		class_1657 player = field_28963.field_14140;
		class_1937 world = player.method_5770();

		class_3966 hitResult = new class_3966(field_28962, hitPosition.method_1031(field_28962.method_23317(), field_28962.method_23318(), field_28962.method_23321()));
		class_1269 result = UseEntityCallback.EVENT.invoker().interact(player, world, hand, field_28962, hitResult);

		if (result != class_1269.field_5811) {
			info.cancel();
		}
	}

	@Inject(method = "interact(Lnet/minecraft/util/Hand;)V", at = @At(value = "HEAD"), cancellable = true)
	public void onPlayerInteractEntity(class_1268 hand, CallbackInfo info) {
		class_1657 player = field_28963.field_14140;
		class_1937 world = player.method_5770();

		class_1269 result = UseEntityCallback.EVENT.invoker().interact(player, world, hand, field_28962, null);

		if (result != class_1269.field_5811) {
			info.cancel();
		}
	}
}
