/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gametest;

import com.mojang.brigadier.arguments.ArgumentType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.gametest.FabricGameTestHelper;
import net.minecraft.class_155;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2378;
import net.minecraft.class_4526;
import net.minecraft.class_4530;

@Mixin(class_2316.class)
public abstract class ArgumentTypesMixin {
	@Shadow
	private static <A extends ArgumentType<?>, T extends class_2314.class_7217<A>> class_2314<A, T> register(class_2378<class_2314<?, ?>> registry, String string, Class<? extends A> clazz, class_2314<A, T> argumentSerializer) {
		throw new AssertionError("Nope.");
	}

	@Inject(method = "register(Lnet/minecraft/registry/Registry;)Lnet/minecraft/command/argument/serialize/ArgumentSerializer;", at = @At("RETURN"))
	private static void register(class_2378<class_2314<?, ?>> registry, CallbackInfoReturnable<class_2314<?, ?>> ci) {
		// Registered by vanilla when isDevelopment is enabled.
		if (FabricGameTestHelper.COMMAND_ENABLED && !class_155.field_1125) {
			register(registry, "test_argument", class_4530.class, class_2319.method_41999(class_4530::method_22371));
			register(registry, "test_class", class_4526.class, class_2319.method_41999(class_4526::method_22370));
		}
	}
}
