/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gametest;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.impl.gametest.FabricGameTestHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_7654;
import net.minecraft.class_7871;

@Mixin(class_3485.class)
public abstract class StructureTemplateManagerMixin {
	@Shadow
	private class_3300 resourceManager;

	@Shadow
	public abstract class_3499 createTemplate(class_2487 nbt);

	private Optional<class_3499> fabric_loadSnbtFromResource(class_2960 id) {
		class_2960 path = FabricGameTestHelper.GAMETEST_STRUCTURE_FINDER.method_45112(id);
		Optional<class_3298> resource = this.resourceManager.method_14486(path);

		if (resource.isPresent()) {
			try {
				String snbt = IOUtils.toString(resource.get().method_43039());
				class_2487 nbt = class_2512.method_32260(snbt);
				return Optional.of(this.createTemplate(nbt));
			} catch (IOException | CommandSyntaxException e) {
				throw new RuntimeException("Failed to load GameTest structure " + id, e);
			}
		}

		return Optional.empty();
	}

	private Stream<class_2960> fabric_streamTemplatesFromResource() {
		class_7654 finder = FabricGameTestHelper.GAMETEST_STRUCTURE_FINDER;
		return finder.method_45113(this.resourceManager).keySet().stream().map(finder::method_45115);
	}

	@Inject(method = "<init>", at = @At(value = "INVOKE", target = "Lcom/google/common/collect/ImmutableList$Builder;add(Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList$Builder;", ordinal = 2, shift = At.Shift.AFTER, remap = false), locals = LocalCapture.CAPTURE_FAILHARD)
	private void addFabricTemplateProvider(class_3300 resourceManager, class_32.class_5143 session, DataFixer dataFixer, class_7871<class_2248> blockLookup, CallbackInfo ci, ImmutableList.Builder<class_3485.class_7514> builder) {
		builder.add(new class_3485.class_7514(this::fabric_loadSnbtFromResource, this::fabric_streamTemplatesFromResource));
	}
}
