/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.gametest;

import java.lang.reflect.Method;
import java.util.Locale;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.gametest.FabricGameTestHelper;
import net.fabricmc.fabric.impl.gametest.FabricGameTestModInitializer;
import net.minecraft.class_4519;
import net.minecraft.class_4525;
import net.minecraft.class_4529;
import net.minecraft.class_6302;

@Mixin(class_4519.class)
public abstract class TestFunctionsMixin {
	@Inject(at = @At("HEAD"), method = "getTestFunction(Ljava/lang/reflect/Method;)Lnet/minecraft/test/TestFunction;", cancellable = true)
	private static void getTestFunction(Method method, CallbackInfoReturnable<class_4529> cir) {
		class_6302 gameTest = method.getAnnotation(class_6302.class);
		String testSuiteName = method.getDeclaringClass().getSimpleName().toLowerCase(Locale.ROOT);
		String testCaseName = testSuiteName + "." + method.getName().toLowerCase(Locale.ROOT);

		String modId = FabricGameTestModInitializer.getModIdForTestClass(method.getDeclaringClass());
		String structureName = "%s:%s".formatted(modId, testCaseName);

		if (!gameTest.method_35936().isEmpty()) {
			structureName = gameTest.method_35936();
		}

		class_4529 testFunction = new class_4529(gameTest.method_35933(),
				testCaseName,
				structureName,
				class_4525.method_29408(gameTest.method_35934()),
				gameTest.method_35932(),
				gameTest.method_35937(),
				gameTest.method_35935(),
				gameTest.method_57962(),
				gameTest.method_35938(),
				gameTest.method_35939(),
				gameTest.method_57098(),
				FabricGameTestHelper.getTestMethodInvoker(method)
		);

		cir.setReturnValue(testFunction);
	}
}
