/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.serialization.Decoder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import net.fabricmc.fabric.impl.item.EnchantmentUtil;
import net.minecraft.class_1887;
import net.minecraft.class_2385;
import net.minecraft.class_3298;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7655;
import net.minecraft.class_9248;

@Mixin(class_7655.class)
abstract class RegistryLoaderMixin {
	@WrapOperation(
			method = "parseAndAdd",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/registry/MutableRegistry;add(Lnet/minecraft/registry/RegistryKey;Ljava/lang/Object;Lnet/minecraft/registry/entry/RegistryEntryInfo;)Lnet/minecraft/registry/entry/RegistryEntry$Reference;"
			)
	)
	@SuppressWarnings("unchecked")
	private static <T> class_6880.class_6883<T> enchantmentKey(
			class_2385<T> instance,
			class_5321<T> objectKey,
			Object object,
			class_9248 registryEntryInfo,
			Operation<class_6880.class_6883<T>> original,
			class_2385<T> registry,
			Decoder<T> decoder,
			class_6903<JsonElement> ops,
			class_5321<T> registryKey,
			class_3298 resource,
			class_9248 entryInfo
	) {
		if (object instanceof class_1887 enchantment) {
			object = EnchantmentUtil.modify((class_5321<class_1887>) objectKey, enchantment, EnchantmentUtil.determineSource(resource));
		}

		return original.call(instance, registryKey, object, registryEntryInfo);
	}
}
