/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.item.v1;

import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_6880;

/**
 * Fabric-provided extensions for {@link class_1799}.
 * This interface is automatically implemented on all item stacks via Mixin and interface injection.
 */
public interface FabricItemStack {
	/**
	 * Return a leftover item for use in recipes.
	 *
	 * <p>See {@link FabricItem#getRecipeRemainder(class_1799)} for a more in depth description.
	 *
	 * <p>Stack-aware version of {@link class_1792#method_7858()}.
	 *
	 * @return the leftover item
	 */
	default class_1799 getRecipeRemainder() {
		return ((class_1799) this).method_7909().getRecipeRemainder((class_1799) this);
	}

	/**
	 * Determines whether this {@link class_1799} can be enchanted with the given {@link class_1887}.
	 *
	 * <p>When checking whether an enchantment can be applied to an {@link class_1799}, use this method instead of
	 * {@link class_1887#method_8192(class_1799)} or {@link class_1887#method_58444(class_1799)}, with the appropriate
	 * {@link EnchantingContext}.</p>
	 *
	 * @param enchantment the enchantment to check
	 * @param context the context in which the enchantment is being checked
	 * @return whether the enchantment is allowed to apply to the stack
	 * @see FabricItem#canBeEnchantedWith(class_1799, class_6880, EnchantingContext)
	 */
	default boolean canBeEnchantedWith(class_6880<class_1887> enchantment, EnchantingContext context) {
		TriState result = EnchantmentEvents.ALLOW_ENCHANTING.invoker().allowEnchanting(
				enchantment,
				(class_1799) this,
				context
		);
		return result.orElseGet(() -> ((class_1799) this).method_7909().canBeEnchantedWith((class_1799) this, enchantment, context));
	}
}
