/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item;

import java.util.function.Consumer;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import net.fabricmc.fabric.api.item.v1.CustomDamageHandler;
import net.fabricmc.fabric.api.item.v1.FabricItemStack;
import net.fabricmc.fabric.impl.item.ItemExtensions;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@Mixin(class_1799.class)
public abstract class ItemStackMixin implements FabricItemStack {
	@Shadow
	public abstract class_1792 getItem();

	@Shadow
	public abstract void decrement(int amount);

	@WrapOperation(method = "damage(ILnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/EquipmentSlot;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;damage(ILnet/minecraft/server/world/ServerWorld;Lnet/minecraft/server/network/ServerPlayerEntity;Ljava/util/function/Consumer;)V"))
	private void hookDamage(class_1799 instance, int amount, class_3218 serverWorld, class_3222 serverPlayerEntity, Consumer<class_1792> consumer, Operation<Void> original, @Local(argsOnly = true) class_1309 entity, @Local(argsOnly = true) class_1304 slot) {
		CustomDamageHandler handler = ((ItemExtensions) getItem()).fabric_getCustomDamageHandler();

		/*
			This is called by creative mode players, post-24w21a.
			The other damage method (which original.call discards) handles the creative mode check.
			Since it doesn't make sense to call an event to calculate a to-be-discarded value
			(and to prevent mods from breaking item stacks in Creative mode),
			we preserve the pre-24w21a behavior of not calling in creative mode.
		*/

		if (handler != null && !entity.method_56992()) {
			// Track whether an item has been broken by custom handler
			MutableBoolean mut = new MutableBoolean(false);
			amount = handler.damage((class_1799) (Object) this, amount, entity, slot, () -> {
				mut.setTrue();
				this.decrement(1);
				consumer.accept(this.getItem());
			});

			// If item is broken, there's no reason to call the original.
			if (mut.booleanValue()) return;
		}

		original.call(instance, amount, serverWorld, serverPlayerEntity, consumer);
	}
}
