/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item;

import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.item.v1.CustomDamageHandler;
import net.fabricmc.fabric.api.item.v1.FabricItemStack;
import net.fabricmc.fabric.impl.item.ComponentTooltipAppenderRegistryImpl;
import net.fabricmc.fabric.impl.item.ItemExtensions;
import net.fabricmc.fabric.impl.item.VanillaTooltipAppenderOrder;
import net.minecraft.class_10712;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

@Mixin(class_1799.class)
public abstract class ItemStackMixin implements FabricItemStack {
	@Shadow
	public abstract class_1792 getItem();

	@Shadow
	public abstract void decrement(int amount);

	@WrapOperation(method = "damage(ILnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/EquipmentSlot;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;damage(ILnet/minecraft/server/world/ServerWorld;Lnet/minecraft/server/network/ServerPlayerEntity;Ljava/util/function/Consumer;)V"))
	private void hookDamage(class_1799 instance, int amount, class_3218 serverWorld, class_3222 serverPlayerEntity, Consumer<class_1792> consumer, Operation<Void> original, @Local(argsOnly = true) class_1309 entity, @Local(argsOnly = true) class_1304 slot) {
		CustomDamageHandler handler = ((ItemExtensions) getItem()).fabric_getCustomDamageHandler();

		/*
			This is called by creative mode players, post-24w21a.
			The other damage method (which original.call discards) handles the creative mode check.
			Since it doesn't make sense to call an event to calculate a to-be-discarded value
			(and to prevent mods from breaking item stacks in Creative mode),
			we preserve the pre-24w21a behavior of not calling in creative mode.
		*/

		if (handler != null && !entity.method_56992()) {
			// Track whether an item has been broken by custom handler
			MutableBoolean mut = new MutableBoolean(false);
			amount = handler.damage((class_1799) (Object) this, amount, entity, slot, () -> {
				mut.setTrue();
				this.decrement(1);
				consumer.accept(this.getItem());
			});

			// If item is broken, there's no reason to call the original.
			if (mut.booleanValue()) return;
		}

		original.call(instance, amount, serverWorld, serverPlayerEntity, consumer);
	}

	@ModifyArg(method = "appendTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;appendComponentTooltip(Lnet/minecraft/component/ComponentType;Lnet/minecraft/item/Item$TooltipContext;Lnet/minecraft/component/type/TooltipDisplayComponent;Ljava/util/function/Consumer;Lnet/minecraft/item/tooltip/TooltipType;)V"))
	private class_9331<?> preAppendComponentTooltip(
			class_9331<?> componentType,
			@Local(argsOnly = true) class_1792.class_9635 context,
			@Local(argsOnly = true) class_10712 displayComponent,
			@Local(argsOnly = true) class_1836 type,
			@Local(argsOnly = true) Consumer<class_2561> textConsumer,
			@Share("index") LocalIntRef index
	) {
		preAppendTooltip(componentType, context, displayComponent, textConsumer, type, index);
		return componentType;
	}

	@ModifyArg(method = "appendTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/component/type/TooltipDisplayComponent;shouldDisplay(Lnet/minecraft/component/ComponentType;)Z"))
	private class_9331<?> preShouldDisplay(
			class_9331<?> componentType,
			@Local(argsOnly = true) class_1792.class_9635 context,
			@Local(argsOnly = true) class_10712 displayComponent,
			@Local(argsOnly = true) class_1836 type,
			@Local(argsOnly = true) Consumer<class_2561> textConsumer,
			@Share("index") LocalIntRef index
	) {
		preAppendTooltip(componentType, context, displayComponent, textConsumer, type, index);
		return componentType;
	}

	@Inject(method = "appendTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;appendAttributeModifiersTooltip(Ljava/util/function/Consumer;Lnet/minecraft/component/type/TooltipDisplayComponent;Lnet/minecraft/entity/player/PlayerEntity;)V"))
	private void preAttributeModifiers(
			class_1792.class_9635 context,
			class_10712 displayComponent,
			@Nullable class_1657 player,
			class_1836 type,
			Consumer<class_2561> textConsumer,
			CallbackInfo ci,
			@Share("index") LocalIntRef index
	) {
		// Special case: attribute modifiers are extracted into a separate method
		preAppendTooltip(class_9334.field_49636, context, displayComponent, textConsumer, type, index);
	}

	@Inject(method = "appendTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/registry/DefaultedRegistry;getId(Ljava/lang/Object;)Lnet/minecraft/util/Identifier;"))
	private void postTooltipsAdvanced(
			class_1792.class_9635 context,
			class_10712 displayComponent,
			@Nullable class_1657 player,
			class_1836 type,
			Consumer<class_2561> textConsumer,
			CallbackInfo ci,
			@Share("index") LocalIntRef index
	) {
		preAppendTooltip(null, context, displayComponent, textConsumer, type, index);
	}

	@ModifyExpressionValue(method = "appendTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/tooltip/TooltipType;isAdvanced()Z"))
	private boolean postTooltipsNonAdvanced(
			boolean isAdvanced,
			class_1792.class_9635 context,
			class_10712 displayComponent,
			@Nullable class_1657 player,
			class_1836 type,
			Consumer<class_2561> textConsumer,
			@Share("index") LocalIntRef index
	) {
		if (!isAdvanced) {
			preAppendTooltip(null, context, displayComponent, textConsumer, type, index);
		}

		return isAdvanced;
	}

	@Unique
	private void preAppendTooltip(
			@Nullable class_9331<?> componentType,
			class_1792.class_9635 context,
			class_10712 displayComponent,
			Consumer<class_2561> textConsumer,
			class_1836 tooltipType,
			LocalIntRef index
	) {
		if (!ComponentTooltipAppenderRegistryImpl.hasModdedEntries()) {
			return;
		}

		if (index.get() == 0) {
			ComponentTooltipAppenderRegistryImpl.onFirst((class_1799) (Object) this, context, displayComponent, textConsumer, tooltipType);
		}

		List<class_9331<?>> vanillaOrder = VanillaTooltipAppenderOrder.getVanillaOrder();

		if (index.get() > vanillaOrder.size()) {
			return;
		}

		// Find out which vanilla tooltip appenders we may have skipped over and run their anchored appenders first

		while (true) {
			if (index.get() > 0) {
				class_9331<?> prevComponentInOrder = vanillaOrder.get(index.get() - 1);
				HashSet<class_9331<?>> cycleDetector = new HashSet<>();
				cycleDetector.add(prevComponentInOrder);
				ComponentTooltipAppenderRegistryImpl.onAfter((class_1799) (Object) this, prevComponentInOrder, context, displayComponent, textConsumer, tooltipType, cycleDetector);
			}

			if (index.get() == vanillaOrder.size()) {
				index.set(index.get() + 1);
				break;
			}

			class_9331<?> componentInOrder = vanillaOrder.get(index.get());
			HashSet<class_9331<?>> cycleDetector = new HashSet<>();
			cycleDetector.add(componentInOrder);
			ComponentTooltipAppenderRegistryImpl.onBefore((class_1799) (Object) this, componentInOrder, context, displayComponent, textConsumer, tooltipType, cycleDetector);
			index.set(index.get() + 1);

			if (componentInOrder == componentType) {
				break;
			}
		}

		if (componentType == null) {
			ComponentTooltipAppenderRegistryImpl.onLast((class_1799) (Object) this, context, displayComponent, textConsumer, tooltipType);
		}
	}
}
