/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.itemgroup;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.impl.itemgroup.FabricItemGroupImpl;
import net.minecraft.class_1761;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_481;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class FabricCreativeGuiComponents {
	private static final class_2960 BUTTON_TEX = class_2960.method_60655("fabric", "textures/gui/creative_buttons.png");
	private static final double TABS_PER_PAGE = FabricItemGroupImpl.TABS_PER_PAGE;
	public static final Set<class_1761> COMMON_GROUPS = Set.of(class_7706.field_40200, class_7706.field_40206, class_7706.field_40199, class_7706.field_41063).stream()
			.map(class_7923.field_44687::method_31140)
			.collect(Collectors.toSet());

	public static int getPageCount() {
		return (int) Math.ceil((class_7706.method_47335().size() - COMMON_GROUPS.stream().filter(class_1761::method_47311).count()) / TABS_PER_PAGE);
	}

	public static class ItemGroupButtonWidget extends class_4185 {
		final class_481 screen;
		final Type type;

		public ItemGroupButtonWidget(int x, int y, Type type, class_481 screen) {
			super(x, y, 10, 12, type.text, (bw) -> type.clickConsumer.accept(screen), class_4185.field_40754);
			this.type = type;
			this.screen = screen;
		}

		@Override
		protected void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
			this.field_22763 = type.isEnabled.test(screen);
			this.field_22764 = screen.hasAdditionalPages();

			if (!this.field_22764) {
				return;
			}

			int u = field_22763 && this.method_49606() ? 20 : 0;
			int v = field_22763 ? 0 : 12;
			drawContext.method_25290(class_1921::method_62277, BUTTON_TEX, this.method_46426(), this.method_46427(), u + (type == Type.NEXT ? 10 : 0), v, 10, 12, 256, 256);

			if (this.method_49606()) {
				drawContext.method_51438(class_310.method_1551().field_1772, class_2561.method_43469("fabric.gui.creativeTabPage", screen.getCurrentPage() + 1, getPageCount()), mouseX, mouseY);
			}
		}
	}

	public enum Type {
		NEXT(class_2561.method_43470(">"), class_481::switchToNextPage, screen -> screen.getCurrentPage() + 1 < screen.getPageCount()),
		PREVIOUS(class_2561.method_43470("<"), class_481::switchToPreviousPage, screen -> screen.getCurrentPage() != 0);

		final class_2561 text;
		final Consumer<class_481> clickConsumer;
		final Predicate<class_481> isEnabled;

		Type(class_2561 text, Consumer<class_481> clickConsumer, Predicate<class_481> isEnabled) {
			this.text = text;
			this.clickConsumer = clickConsumer;
			this.isEnabled = isEnabled;
		}
	}
}
