/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_156;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public final class ModelLoadingPluginManager {
    private static final List<ModelLoadingPlugin> PLUGINS = new ArrayList<ModelLoadingPlugin>();
    private static final List<PreparablePluginHolder<?>> PREPARABLE_PLUGINS = new ArrayList();
    public static final ThreadLocal<List<ModelLoadingPlugin>> CURRENT_PLUGINS = new ThreadLocal();

    public static void registerPlugin(ModelLoadingPlugin plugin) {
        Objects.requireNonNull(plugin, "plugin must not be null");
        PLUGINS.add(plugin);
    }

    public static <T> void registerPlugin(PreparableModelLoadingPlugin.DataLoader<T> loader, PreparableModelLoadingPlugin<T> plugin) {
        Objects.requireNonNull(loader, "data loader must not be null");
        Objects.requireNonNull(plugin, "plugin must not be null");
        PREPARABLE_PLUGINS.add(new PreparablePluginHolder<T>(loader, plugin));
    }

    public static CompletableFuture<List<ModelLoadingPlugin>> preparePlugins(class_3300 resourceManager, Executor executor) {
        ArrayList<CompletableFuture<ModelLoadingPlugin>> futures = new ArrayList<CompletableFuture<ModelLoadingPlugin>>();
        for (ModelLoadingPlugin modelLoadingPlugin : PLUGINS) {
            futures.add(CompletableFuture.completedFuture(modelLoadingPlugin));
        }
        for (PreparablePluginHolder preparablePluginHolder : PREPARABLE_PLUGINS) {
            futures.add(ModelLoadingPluginManager.preparePlugin(preparablePluginHolder, resourceManager, executor));
        }
        return class_156.method_33791(futures);
    }

    private static <T> CompletableFuture<ModelLoadingPlugin> preparePlugin(PreparablePluginHolder<T> holder, class_3300 resourceManager, Executor executor) {
        CompletableFuture dataFuture = holder.loader.load(resourceManager, executor);
        return dataFuture.thenApply(data -> pluginContext -> holder.plugin.initialize(data, pluginContext));
    }

    private ModelLoadingPluginManager() {
    }

    @Environment(value=EnvType.CLIENT)
    private record PreparablePluginHolder<T>(PreparableModelLoadingPlugin.DataLoader<T> loader, PreparableModelLoadingPlugin<T> plugin) {
    }
}

