/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.model.loading;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingConstants;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.minecraft.class_10097;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_9824;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_10097.class})
abstract class ReferencedModelsCollectorMixin {
    @Unique
    @Nullable
    private ModelLoadingEventDispatcher fabric_eventDispatcher;

    ReferencedModelsCollectorMixin() {
    }

    @Shadow
    abstract class_1100 method_62638(class_2960 var1);

    @Shadow
    abstract void method_62635(class_1091 var1, class_1100 var2);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onReturnInit(CallbackInfo ci) {
        this.fabric_eventDispatcher = ModelLoadingEventDispatcher.CURRENT.get();
    }

    @Inject(method={"addBlockStates"}, at={@At(value="RETURN")})
    private void onAddStandardModels(class_9824.class_10095 blockStateModels, CallbackInfo ci) {
        if (this.fabric_eventDispatcher == null) {
            return;
        }
        this.fabric_eventDispatcher.addExtraModels(id -> {
            class_1091 modelId = ModelLoadingConstants.toResourceModelId(id);
            class_1100 unbakedModel = this.method_62638((class_2960)id);
            this.method_62635(modelId, unbakedModel);
        });
    }

    @ModifyVariable(method={"getModel"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    @Nullable
    private class_1100 onLoadResourceModel(@Nullable class_1100 model, class_2960 id) {
        if (this.fabric_eventDispatcher == null) {
            return model;
        }
        class_1100 resolvedModel = this.fabric_eventDispatcher.resolveModel(id);
        if (resolvedModel != null) {
            model = resolvedModel;
        }
        return this.fabric_eventDispatcher.modifyModelOnLoad(model, id, null);
    }

    @ModifyVariable(method={"addTopLevelModel"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1100 onAddTopLevelModel(class_1100 model, class_1091 modelId) {
        if (this.fabric_eventDispatcher == null) {
            return model;
        }
        if (ModelLoadingConstants.isResourceModelId(modelId)) {
            return model;
        }
        return this.fabric_eventDispatcher.modifyModelOnLoad(model, null, modelId);
    }
}

