/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.model.loading.v1;

import net.minecraft.class_1087;
import net.minecraft.class_2680;
import net.minecraft.class_7775;
import net.minecraft.class_9979;

/**
 * A simple implementation of {@link class_9979} that delegates all method calls to the {@link #wrapped} field.
 * Implementations must set the {@link #wrapped} field somehow.
 */
public abstract class WrapperGroupableModel implements class_9979 {
	protected class_9979 wrapped;

	protected WrapperGroupableModel() {
	}

	protected WrapperGroupableModel(class_9979 wrapped) {
		this.wrapped = wrapped;
	}

	@Override
	public void method_62326(class_10103 resolver) {
		wrapped.method_62326(resolver);
	}

	@Override
	public class_1087 method_65542(class_7775 baker) {
		return wrapped.method_65542(baker);
	}

	@Override
	public Object method_62332(class_2680 state) {
		return wrapped.method_62332(state);
	}
}
