/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ModelLoadingPluginContextImpl
implements ModelLoadingPlugin.Context {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelLoadingPluginContextImpl.class);
    final Set<class_2960> extraModels = new LinkedHashSet<class_2960>();
    final Map<class_2248, BlockStateResolver> blockStateResolvers = new IdentityHashMap<class_2248, BlockStateResolver>();
    private static final class_2960[] MODEL_MODIFIER_PHASES = new class_2960[]{ModelModifier.OVERRIDE_PHASE, ModelModifier.DEFAULT_PHASE, ModelModifier.WRAP_PHASE, ModelModifier.WRAP_LAST_PHASE};
    private final Event<ModelModifier.OnLoad> onLoadModifiers = EventFactory.createWithPhases(ModelModifier.OnLoad.class, modifiers -> (model, context) -> {
        for (ModelModifier.OnLoad modifier : modifiers) {
            try {
                model = modifier.modifyModelOnLoad(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify unbaked model on load", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.BeforeBake> beforeBakeModifiers = EventFactory.createWithPhases(ModelModifier.BeforeBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.BeforeBake modifier : modifiers) {
            try {
                model = modifier.modifyModelBeforeBake(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify unbaked model before bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.AfterBake> afterBakeModifiers = EventFactory.createWithPhases(ModelModifier.AfterBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.AfterBake modifier : modifiers) {
            try {
                model = modifier.modifyModelAfterBake(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify baked model after bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.OnLoadBlock> onLoadBlockModifiers = EventFactory.createWithPhases(ModelModifier.OnLoadBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.OnLoadBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelOnLoad(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify unbaked block model on load", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.BeforeBakeBlock> beforeBakeBlockModifiers = EventFactory.createWithPhases(ModelModifier.BeforeBakeBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.BeforeBakeBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelBeforeBake(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify unbaked block model before bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.AfterBakeBlock> afterBakeBlockModifiers = EventFactory.createWithPhases(ModelModifier.AfterBakeBlock.class, modifiers -> (model, context) -> {
        for (ModelModifier.AfterBakeBlock modifier : modifiers) {
            try {
                model = modifier.modifyModelAfterBake(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify baked block model after bake", (Throwable)exception);
            }
        }
        return model;
    }, (class_2960[])MODEL_MODIFIER_PHASES);

    @Override
    public void addModels(class_2960 ... ids) {
        for (class_2960 id : ids) {
            this.extraModels.add(id);
        }
    }

    @Override
    public void addModels(Collection<? extends class_2960> ids) {
        this.extraModels.addAll(ids);
    }

    @Override
    public void registerBlockStateResolver(class_2248 block, BlockStateResolver resolver) {
        Objects.requireNonNull(block, "block cannot be null");
        Objects.requireNonNull(resolver, "resolver cannot be null");
        Optional optionalKey = class_7923.field_41175.method_29113((Object)block);
        if (optionalKey.isEmpty()) {
            throw new IllegalArgumentException("Received unregistered block");
        }
        if (this.blockStateResolvers.put(block, resolver) != null) {
            throw new IllegalArgumentException("Duplicate block state resolver for " + String.valueOf(block));
        }
    }

    @Override
    public Event<ModelModifier.OnLoad> modifyModelOnLoad() {
        return this.onLoadModifiers;
    }

    @Override
    public Event<ModelModifier.BeforeBake> modifyModelBeforeBake() {
        return this.beforeBakeModifiers;
    }

    @Override
    public Event<ModelModifier.AfterBake> modifyModelAfterBake() {
        return this.afterBakeModifiers;
    }

    @Override
    public Event<ModelModifier.OnLoadBlock> modifyBlockModelOnLoad() {
        return this.onLoadBlockModifiers;
    }

    @Override
    public Event<ModelModifier.BeforeBakeBlock> modifyBlockModelBeforeBake() {
        return this.beforeBakeBlockModifiers;
    }

    @Override
    public Event<ModelModifier.AfterBakeBlock> modifyBlockModelAfterBake() {
        return this.afterBakeBlockModifiers;
    }
}

