/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.particle;

import java.util.List;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.fabricmc.fabric.mixin.client.particle.ParticleManagerAccessor;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_702;

public class FabricSpriteProviderImpl implements FabricSpriteProvider {
	private final class_702 particleManager;
	private final class_4002 delegate;

	FabricSpriteProviderImpl(class_702 particleManager, class_4002 delegate) {
		this.particleManager = particleManager;
		this.delegate = delegate;
	}

	@Override
	public class_1059 getAtlas() {
		return ((ParticleManagerAccessor) particleManager).getParticleAtlasTexture();
	}

	@Override
	public List<class_1058> getSprites() {
		return ((ParticleManagerAccessor.SimpleSpriteProviderAccessor) delegate).getSprites();
	}

	@Override
	public class_1058 method_18138(int i, int j) {
		return delegate.method_18138(i, j);
	}

	@Override
	public class_1058 method_18139(class_5819 random) {
		return delegate.method_18139(random);
	}
}
