/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.particle;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import net.fabricmc.fabric.api.particle.v1.FabricBlockStateParticleEffect;
import net.fabricmc.fabric.impl.particle.BlockStateParticleEffectExtension;
import net.fabricmc.fabric.impl.particle.ExtendedBlockStateParticleEffectPacketCodec;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@Mixin(class_2388.class)
abstract class BlockStateParticleEffectMixin implements FabricBlockStateParticleEffect, BlockStateParticleEffectExtension {
	@Nullable
	@Unique
	private class_2338 blockPos;

	@Override
	@Nullable
	public class_2338 getBlockPos() {
		return blockPos;
	}

	@Override
	public void fabric_setBlockPos(@Nullable class_2338 pos) {
		blockPos = pos;
	}

	@ModifyReturnValue(method = "createPacketCodec", at = @At("RETURN"))
	private static class_9139<? super class_9129, class_2388> modifyPacketCodec(class_9139<? super class_9129, class_2388> codec) {
		return new ExtendedBlockStateParticleEffectPacketCodec(codec);
	}
}
