/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.material;

import net.minecraft.class_1921;
import net.minecraft.class_4696;

/**
 * Controls how sprite pixels will be blended with the scene.
 */
public enum BlendMode {
	/**
	 * Emulate blending behavior of the {@link class_1921} associated with the block state through
	 * {@link class_4696}.
	 */
	DEFAULT(null),

	/**
	 * Fully opaque with depth test, no blending. Used for most normal blocks.
	 */
	SOLID(class_1921.method_23577()),

	/**
	 * Pixels with alpha &gt; 0.5 are rendered as if {@code SOLID}. Other pixels are not rendered.
	 * Texture mip-map enabled.  Used for leaves.
	 */
	CUTOUT_MIPPED(class_1921.method_23579()),

	/**
	 * Pixels with alpha &gt; 0.5 are rendered as if {@code SOLID}. Other pixels are not rendered.
	 * Texture mip-map disabled.  Used for iron bars, glass and other cutout sprites with hard edges.
	 */
	CUTOUT(class_1921.method_23581()),

	/**
	 * Pixels are blended with the background according to alpha color values. Some performance cost,
	 * use in moderation. Texture mip-map enabled.  Used for stained glass.
	 */
	TRANSLUCENT(class_1921.method_23583());

	public final class_1921 blockRenderLayer;

	BlendMode(class_1921 blockRenderLayer) {
		this.blockRenderLayer = blockRenderLayer;
	}

	public static BlendMode fromRenderLayer(class_1921 renderLayer) {
		if (renderLayer == class_1921.method_23577()) {
			return SOLID;
		} else if (renderLayer == class_1921.method_23579()) {
			return CUTOUT_MIPPED;
		} else if (renderLayer == class_1921.method_23581()) {
			return CUTOUT;
		} else if (renderLayer == class_1921.method_23583()) {
			return TRANSLUCENT;
		} else {
			return DEFAULT;
		}
	}
}
