/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.model;

import java.util.Arrays;
import java.util.List;

import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.minecraft.class_1059;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_777;

/**
 * Collection of utilities for model implementations.
 */
public final class ModelHelper {
	/** @see #faceFromIndex(int) */
	private static final class_2350[] FACES = Arrays.copyOf(class_2350.values(), 7);

	/** Result from {@link #toFaceIndex(class_2350)} for null values. */
	public static final int NULL_FACE_ID = 6;

	private ModelHelper() { }

	/**
	 * Convenient way to encode faces that may be null.
	 * Null is returned as {@link #NULL_FACE_ID}.
	 * Use {@link #faceFromIndex(int)} to retrieve encoded face.
	 */
	public static int toFaceIndex(@Nullable class_2350 face) {
		return face == null ? NULL_FACE_ID : face.method_10146();
	}

	/**
	 * Use to decode a result from {@link #toFaceIndex(class_2350)}.
	 * Return value will be null if encoded value was null.
	 * Can also be used for no-allocation iteration of {@link class_2350#values()},
	 * optionally including the null face. (Use &lt; or  &lt;= {@link #NULL_FACE_ID}
	 * to exclude or include the null value, respectively.)
	 */
	@Nullable
	public static class_2350 faceFromIndex(int faceIndex) {
		return FACES[faceIndex];
	}

	/**
	 * Converts a mesh into an array of lists of vanilla baked quads.
	 * Useful for creating vanilla baked models when required for compatibility.
	 * The array indexes correspond to {@link class_2350#method_10151()} with the
	 * addition of {@link #NULL_FACE_ID}.
	 *
	 * <p>Retrieves sprites from the block texture atlas via {@link SpriteFinder}.
	 */
	public static List<class_777>[] toQuadLists(Mesh mesh) {
		SpriteFinder finder = class_310.method_1551().method_1554().method_24153(class_1059.field_5275).spriteFinder();

		@SuppressWarnings("unchecked")
		final ImmutableList.Builder<class_777>[] builders = new ImmutableList.Builder[7];

		for (int i = 0; i < 7; i++) {
			builders[i] = ImmutableList.builder();
		}

		mesh.forEach(q -> {
			class_2350 cullFace = q.cullFace();
			builders[cullFace == null ? NULL_FACE_ID : cullFace.method_10146()].add(q.toBakedQuad(finder.find(q)));
		});

		@SuppressWarnings("unchecked")
		List<class_777>[] result = new List[7];

		for (int i = 0; i < 7; i++) {
			result[i] = builders[i].build();
		}

		return result;
	}
}
