/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Supplier;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_4696;
import net.minecraft.class_5819;

/**
 * Holds, manages, and provides access to the block/world related state
 * needed to render quads.
 *
 * <p>Exception: per-block position offsets are tracked in {@link ChunkRenderInfo}
 * so they can be applied together with chunk offsets.
 */
public class BlockRenderInfo {
	private final class_324 blockColorMap = class_310.method_1551().method_1505();
	private final class_2338.class_2339 searchPos = new class_2338.class_2339();

	public class_1920 blockView;
	public class_2338 blockPos;
	public class_2680 blockState;

	boolean useAo;
	boolean defaultAo;
	class_1921 defaultLayer;

	class_5819 random;
	long seed;
	boolean recomputeSeed;
	public final Supplier<class_5819> randomSupplier = () -> {
		long seed = this.seed;

		if (recomputeSeed) {
			seed = blockState.method_26190(blockPos);
			this.seed = seed;
			recomputeSeed = false;
		}

		final class_5819 random = this.random;
		random.method_43052(seed);
		return random;
	};

	private boolean enableCulling;
	private int cullCompletionFlags;
	private int cullResultFlags;

	public void prepareForWorld(class_1920 blockView, boolean enableCulling) {
		this.blockView = blockView;
		this.enableCulling = enableCulling;
	}

	public void prepareForBlock(class_2680 blockState, class_2338 blockPos, boolean modelAo) {
		this.blockPos = blockPos;
		this.blockState = blockState;

		useAo = class_310.method_1588();
		defaultAo = useAo && modelAo && blockState.method_26213() == 0;

		defaultLayer = class_4696.method_23679(blockState);

		cullCompletionFlags = 0;
		cullResultFlags = 0;
	}

	public void release() {
		blockView = null;
		blockPos = null;
		blockState = null;
	}

	int blockColor(int colorIndex) {
		return 0xFF000000 | blockColorMap.method_1697(blockState, blockView, blockPos, colorIndex);
	}

	boolean shouldDrawFace(@Nullable class_2350 face) {
		if (face == null || !enableCulling) {
			return true;
		}

		final int mask = 1 << face.method_10146();

		if ((cullCompletionFlags & mask) == 0) {
			cullCompletionFlags |= mask;

			if (class_2248.method_9607(blockState, blockView.method_8320(searchPos.method_25505(blockPos, face)), face)) {
				cullResultFlags |= mask;
				return true;
			} else {
				return false;
			}
		} else {
			return (cullResultFlags & mask) != 0;
		}
	}

	class_1921 effectiveRenderLayer(BlendMode blendMode) {
		return blendMode == BlendMode.DEFAULT ? this.defaultLayer : blendMode.blockRenderLayer;
	}
}
