/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_853;

/**
 * Implementation of {@link RenderContext} used during terrain rendering.
 * Dispatches calls from models during chunk rebuild to the appropriate consumer,
 * and holds/manages all of the state needed by them.
 */
public class TerrainRenderContext extends AbstractBlockRenderContext {
	public static final ThreadLocal<TerrainRenderContext> POOL = ThreadLocal.withInitial(TerrainRenderContext::new);

	private final ChunkRenderInfo chunkInfo = new ChunkRenderInfo();

	public TerrainRenderContext() {
		overlay = class_4608.field_21444;
		blockInfo.random = class_5819.method_43047();
	}

	@Override
	protected AoCalculator createAoCalc(BlockRenderInfo blockInfo) {
		return new AoCalculator(blockInfo) {
			@Override
			public int light(class_2338 pos, class_2680 state) {
				return chunkInfo.cachedBrightness(pos, state);
			}

			@Override
			public float ao(class_2338 pos, class_2680 state) {
				return chunkInfo.cachedAoLevel(pos, state);
			}
		};
	}

	@Override
	protected class_4588 getVertexConsumer(class_1921 layer) {
		return chunkInfo.getBuffer(layer);
	}

	public void prepare(class_853 blockView, Function<class_1921, class_287> bufferFunc) {
		chunkInfo.prepare(blockView, bufferFunc);
		blockInfo.prepareForWorld(blockView, true);
	}

	public void release() {
		chunkInfo.release();
		blockInfo.release();
	}

	/** Called from chunk renderer hook. */
	public void tessellateBlock(class_2680 blockState, class_2338 blockPos, final class_1087 model, class_4587 matrixStack) {
		try {
			class_243 offset = blockState.method_26226(blockPos);
			matrixStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);

			this.matrix = matrixStack.method_23760().method_23761();
			this.normalMatrix = matrixStack.method_23760().method_23762();

			blockInfo.recomputeSeed = true;

			aoCalc.clear();
			blockInfo.prepareForBlock(blockState, blockPos, model.method_4708());
			model.emitBlockQuads(blockInfo.blockView, blockInfo.blockState, blockInfo.blockPos, blockInfo.randomSupplier, this);
		} catch (Throwable throwable) {
			class_128 crashReport = class_128.method_560(throwable, "Tessellating block in world - Indigo Renderer");
			class_129 crashReportSection = crashReport.method_562("Block being tessellated");
			class_129.method_586(crashReportSection, chunkInfo.blockView, blockPos, blockState);
			throw new class_148(crashReport);
		}
	}
}
