/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractBlockRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5539;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class BlockRenderContext
extends AbstractBlockRenderContext {
    private class_4588 vertexConsumer;

    @Override
    protected AoCalculator createAoCalc(BlockRenderInfo blockInfo) {
        return new AoCalculator(this, blockInfo){

            @Override
            public int light(class_2338 pos, class_2680 state) {
                return AoCalculator.getLightmapCoordinates(this.blockInfo.blockView, state, pos);
            }

            @Override
            public float ao(class_2338 pos, class_2680 state) {
                return AoLuminanceFix.INSTANCE.apply((class_1922)this.blockInfo.blockView, pos, state);
            }
        };
    }

    @Override
    protected class_4588 getVertexConsumer(class_1921 layer) {
        return this.vertexConsumer;
    }

    public void render(class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrixStack, class_4588 buffer, boolean cull, class_5819 random, long seed, int overlay) {
        try {
            class_243 offset = state.method_26226(pos);
            matrixStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
            this.vertexConsumer = buffer;
            this.matrix = matrixStack.method_23760().method_23761();
            this.normalMatrix = matrixStack.method_23760().method_23762();
            this.overlay = overlay;
            this.blockInfo.random = random;
            this.blockInfo.seed = seed;
            this.blockInfo.recomputeSeed = false;
            this.aoCalc.clear();
            this.blockInfo.prepareForWorld(blockView, cull);
            this.blockInfo.prepareForBlock(state, pos, model.method_4708());
            model.emitBlockQuads(blockView, state, pos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block model - Indigo Renderer");
            class_129 crashReportSection = crashReport.method_562("Block model being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)blockView, (class_2338)pos, (class_2680)state);
            throw new class_148(crashReport);
        }
        finally {
            this.blockInfo.release();
            this.blockInfo.random = null;
            this.vertexConsumer = null;
        }
    }
}

