/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BlockRenderInfo {
    private final class_324 blockColorMap = class_310.method_1551().method_1505();
    private final class_2338.class_2339 searchPos = new class_2338.class_2339();
    public class_1920 blockView;
    public class_2338 blockPos;
    public class_2680 blockState;
    boolean useAo;
    boolean defaultAo;
    class_1921 defaultLayer;
    class_5819 random;
    long seed;
    boolean recomputeSeed;
    public final Supplier<class_5819> randomSupplier = () -> {
        long seed = this.seed;
        if (this.recomputeSeed) {
            this.seed = seed = this.blockState.method_26190(this.blockPos);
            this.recomputeSeed = false;
        }
        class_5819 random = this.random;
        random.method_43052(seed);
        return random;
    };
    private boolean enableCulling;
    private int cullCompletionFlags;
    private int cullResultFlags;

    public void prepareForWorld(class_1920 blockView, boolean enableCulling) {
        this.blockView = blockView;
        this.enableCulling = enableCulling;
    }

    public void prepareForBlock(class_2680 blockState, class_2338 blockPos, boolean modelAo) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.useAo = class_310.method_1588();
        this.defaultAo = this.useAo && modelAo && blockState.method_26213() == 0;
        this.defaultLayer = class_4696.method_23679((class_2680)blockState);
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    public void release() {
        this.blockView = null;
        this.blockPos = null;
        this.blockState = null;
    }

    int blockColor(int colorIndex) {
        return 0xFF000000 | this.blockColorMap.method_1697(this.blockState, this.blockView, this.blockPos, colorIndex);
    }

    boolean shouldDrawFace(@Nullable class_2350 face) {
        if (face == null || !this.enableCulling) {
            return true;
        }
        int mask = 1 << face.method_10146();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (class_2248.method_9607((class_2680)this.blockState, (class_2680)this.blockView.method_8320((class_2338)this.searchPos.method_25505((class_2382)this.blockPos, face)), (class_2350)face)) {
                this.cullResultFlags |= mask;
                return true;
            }
            return false;
        }
        return (this.cullResultFlags & mask) != 0;
    }

    class_1921 effectiveRenderLayer(BlendMode blendMode) {
        return blendMode == BlendMode.DEFAULT ? this.defaultLayer : blendMode.blockRenderLayer;
    }
}

