/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.mixin.client.indigo.renderer.ItemRendererAccessor;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_325;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_7837;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private final class_325 colorMap;
    private final class_5819 random = class_5819.method_43047();
    private final Supplier<class_5819> randomSupplier = () -> {
        this.random.method_43052(42L);
        return this.random;
    };
    private class_1799 itemStack;
    private class_811 transformMode;
    private class_4587 matrixStack;
    private class_4597 vertexConsumerProvider;
    private int lightmap;
    private boolean isDefaultTranslucent;
    private boolean isDefaultGlint;
    private boolean isGlintDynamicDisplay;
    private class_4587.class_4665 dynamicDisplayGlintEntry;
    private class_4588 translucentVertexConsumer;
    private class_4588 cutoutVertexConsumer;
    private class_4588 translucentGlintVertexConsumer;
    private class_4588 cutoutGlintVertexConsumer;

    public ItemRenderContext(class_325 colorMap) {
        this.colorMap = colorMap;
    }

    public boolean isFaceCulled(@Nullable class_2350 face) {
        throw new IllegalStateException("isFaceCulled can only be called on a block render context.");
    }

    public class_811 itemTransformationMode() {
        return this.transformMode;
    }

    public void renderModel(class_1799 itemStack, class_811 transformMode, class_4587 matrixStack, class_4597 vertexConsumerProvider, int lightmap, int overlay, class_1087 model) {
        this.itemStack = itemStack;
        this.transformMode = transformMode;
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.computeOutputInfo();
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        model.emitItemQuads(itemStack, this.randomSupplier, (RenderContext)this);
        this.itemStack = null;
        this.matrixStack = null;
        this.vertexConsumerProvider = null;
        this.dynamicDisplayGlintEntry = null;
        this.translucentVertexConsumer = null;
        this.cutoutVertexConsumer = null;
        this.translucentGlintVertexConsumer = null;
        this.cutoutGlintVertexConsumer = null;
    }

    private void computeOutputInfo() {
        this.isDefaultTranslucent = class_4696.method_23678((class_1799)this.itemStack) == class_4722.method_29382();
        this.isDefaultGlint = this.itemStack.method_7958();
        this.isGlintDynamicDisplay = ItemRendererAccessor.fabric_callUsesDynamicDisplay(this.itemStack);
    }

    @Override
    protected void renderQuad(MutableQuadViewImpl quad) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        boolean emissive = mat.emissive();
        class_4588 vertexConsumer = this.getVertexConsumer(mat.blendMode(), mat.glint());
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        if (colorIndex != -1) {
            int itemColor = this.colorMap.method_1704(this.itemStack, colorIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(itemColor, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
            }
        }
    }

    private class_4588 getVertexConsumer(BlendMode blendMode, TriState glintMode) {
        boolean glint;
        boolean translucent;
        if (blendMode == BlendMode.DEFAULT) {
            translucent = this.isDefaultTranslucent;
        } else {
            boolean bl = translucent = blendMode == BlendMode.TRANSLUCENT;
        }
        if (glintMode == TriState.DEFAULT) {
            glint = this.isDefaultGlint;
        } else {
            boolean bl = glint = glintMode == TriState.TRUE;
        }
        if (translucent) {
            if (glint) {
                if (this.translucentGlintVertexConsumer == null) {
                    this.translucentGlintVertexConsumer = this.createVertexConsumer(class_4722.method_29382(), true);
                }
                return this.translucentGlintVertexConsumer;
            }
            if (this.translucentVertexConsumer == null) {
                this.translucentVertexConsumer = this.createVertexConsumer(class_4722.method_29382(), false);
            }
            return this.translucentVertexConsumer;
        }
        if (glint) {
            if (this.cutoutGlintVertexConsumer == null) {
                this.cutoutGlintVertexConsumer = this.createVertexConsumer(class_4722.method_24074(), true);
            }
            return this.cutoutGlintVertexConsumer;
        }
        if (this.cutoutVertexConsumer == null) {
            this.cutoutVertexConsumer = this.createVertexConsumer(class_4722.method_24074(), false);
        }
        return this.cutoutVertexConsumer;
    }

    private class_4588 createVertexConsumer(class_1921 layer, boolean glint) {
        if (this.isGlintDynamicDisplay && glint) {
            if (this.dynamicDisplayGlintEntry == null) {
                this.dynamicDisplayGlintEntry = this.matrixStack.method_23760().method_56822();
                if (this.transformMode == class_811.field_4317) {
                    class_7837.method_46414((Matrix4f)this.dynamicDisplayGlintEntry.method_23761(), (float)0.5f);
                } else if (this.transformMode.method_29998()) {
                    class_7837.method_46414((Matrix4f)this.dynamicDisplayGlintEntry.method_23761(), (float)0.75f);
                }
            }
            return class_918.method_30114((class_4597)this.vertexConsumerProvider, (class_1921)layer, (class_4587.class_4665)this.dynamicDisplayGlintEntry);
        }
        return class_918.method_23181((class_4597)this.vertexConsumerProvider, (class_1921)layer, (boolean)true, (boolean)glint);
    }
}

