/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.rendering;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;

@Environment(EnvType.CLIENT)
public final class BuiltinItemRendererRegistryImpl implements BuiltinItemRendererRegistry {
	public static final BuiltinItemRendererRegistryImpl INSTANCE = new BuiltinItemRendererRegistryImpl();

	private static final Map<class_1792, DynamicItemRenderer> RENDERERS = new HashMap<>();

	private BuiltinItemRendererRegistryImpl() {
	}

	@Override
	public void register(class_1792 item, BuiltinItemRenderer renderer) {
		Objects.requireNonNull(renderer, "renderer is null");
		this.register(item, (stack, mode, matrices, vertexConsumers, light, overlay) -> renderer.render(stack, matrices, vertexConsumers, light, overlay));
	}

	@Override
	public void register(class_1935 item, BuiltinItemRenderer renderer) {
		Objects.requireNonNull(item, "item is null");
		register(item.method_8389(), renderer);
	}

	@Override
	public void register(class_1935 item, DynamicItemRenderer renderer) {
		Objects.requireNonNull(item, "item is null");
		Objects.requireNonNull(item.method_8389(), "item is null");
		Objects.requireNonNull(renderer, "renderer is null");

		if (RENDERERS.putIfAbsent(item.method_8389(), renderer) != null) {
			throw new IllegalArgumentException("Item " + class_2378.field_11142.method_10221(item.method_8389()) + " already has a builtin renderer!");
		}
	}

	@Nullable
	public static DynamicItemRenderer getRenderer(class_1792 item) {
		return RENDERERS.get(item);
	}
}
