/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.rendering;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.client.rendering.ColorProviderRegistryImpl;
import net.minecraft.class_1935;
import net.minecraft.class_2361;
import net.minecraft.class_2378;
import net.minecraft.class_324;
import net.minecraft.class_325;
import net.minecraft.class_326;

@Mixin(class_325.class)
public class MixinItemColorMap implements ColorProviderRegistryImpl.ColorMapperHolder<class_1935, class_326> {
	@Shadow
	@Final
	private class_2361<class_326> providers;

	@Inject(method = "create", at = @At("RETURN"))
	private static void create(class_324 blockMap, CallbackInfoReturnable<class_325> info) {
		ColorProviderRegistryImpl.ITEM.initialize(info.getReturnValue());
	}

	@Override
	public class_326 get(class_1935 item) {
		return providers.method_10200(class_2378.field_11142.method_10206(item.method_8389()));
	}
}
