/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.fabricmc.fabric.api.client.rendering.v1.LayeredDrawerWrapper;
import net.fabricmc.fabric.impl.client.rendering.SubLayer;
import net.fabricmc.fabric.mixin.client.rendering.LayeredDrawerAccessor;
import net.minecraft.class_2960;
import net.minecraft.class_9080;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.VisibleForTesting;

@Environment(value=EnvType.CLIENT)
public final class LayeredDrawerWrapperImpl
implements LayeredDrawerWrapper {
    private final class_9080 base;

    public LayeredDrawerWrapperImpl(class_9080 base) {
        this.base = base;
    }

    private static List<class_9080.class_9081> getLayers(class_9080 drawer) {
        return ((LayeredDrawerAccessor)drawer).getLayers();
    }

    @Override
    public LayeredDrawerWrapper addLayer(IdentifiedLayer layer) {
        this.validateUnique(layer);
        LayeredDrawerWrapperImpl.getLayers(this.base).add(layer);
        return this;
    }

    @Override
    public LayeredDrawerWrapper attachLayerAfter(class_2960 afterThis, IdentifiedLayer layer) {
        this.validateUnique(layer);
        boolean didChange = this.findLayer(afterThis, (l, iterator) -> {
            iterator.add(layer);
            return true;
        });
        if (!didChange) {
            throw new IllegalArgumentException("Layer with identifier " + String.valueOf(afterThis) + " not found");
        }
        return this;
    }

    @Override
    public LayeredDrawerWrapper attachLayerBefore(class_2960 beforeThis, IdentifiedLayer layer) {
        this.validateUnique(layer);
        boolean didChange = this.findLayer(beforeThis, (l, iterator) -> {
            iterator.previous();
            iterator.add(layer);
            iterator.next();
            return true;
        });
        if (!didChange) {
            throw new IllegalArgumentException("Layer with identifier " + String.valueOf(beforeThis) + " not found");
        }
        return this;
    }

    @Override
    public LayeredDrawerWrapper removeLayer(class_2960 identifier) {
        boolean didChange = this.findLayer(identifier, (l, iterator) -> {
            iterator.remove();
            return true;
        });
        if (!didChange) {
            throw new IllegalArgumentException("Layer with identifier " + String.valueOf(identifier) + " not found");
        }
        return this;
    }

    @Override
    public LayeredDrawerWrapper replaceLayer(class_2960 identifier, Function<IdentifiedLayer, IdentifiedLayer> replacer) {
        boolean didChange = this.findLayer(identifier, (l, iterator) -> {
            iterator.set((class_9080.class_9081)replacer.apply((IdentifiedLayer)l));
            return true;
        });
        if (!didChange) {
            throw new IllegalArgumentException("Layer with identifier " + String.valueOf(identifier) + " not found");
        }
        return this;
    }

    @VisibleForTesting
    void validateUnique(IdentifiedLayer layer) {
        this.visitLayers((l, iterator) -> {
            if (LayeredDrawerWrapperImpl.matchesIdentifier(l, layer.id())) {
                throw new IllegalArgumentException("Layer with identifier " + String.valueOf(layer.id()) + " already exists");
            }
            return false;
        });
    }

    @VisibleForTesting
    boolean findLayer(class_2960 identifier, LayerVisitor visitor) {
        MutableBoolean found = new MutableBoolean(false);
        this.visitLayers((l, iterator) -> {
            if (LayeredDrawerWrapperImpl.matchesIdentifier(l, identifier)) {
                found.setTrue();
                return visitor.visit(l, iterator);
            }
            return false;
        });
        return found.booleanValue();
    }

    @VisibleForTesting
    boolean visitLayers(LayerVisitor visitor) {
        return this.visitLayers(LayeredDrawerWrapperImpl.getLayers(this.base), visitor);
    }

    private boolean visitLayers(List<class_9080.class_9081> layers, LayerVisitor visitor) {
        MutableBoolean modified = new MutableBoolean(false);
        ListIterator<class_9080.class_9081> iterator = layers.listIterator();
        while (iterator.hasNext()) {
            class_9080.class_9081 layer = iterator.next();
            if (visitor.visit(layer, iterator)) {
                modified.setTrue();
                continue;
            }
            if (!(layer instanceof SubLayer)) continue;
            SubLayer subLayer = (SubLayer)layer;
            modified.setValue(this.visitLayers(LayeredDrawerWrapperImpl.getLayers(subLayer.delegate()), visitor));
        }
        return modified.booleanValue();
    }

    private static boolean matchesIdentifier(class_9080.class_9081 layer, class_2960 identifier) {
        IdentifiedLayer il;
        return layer instanceof IdentifiedLayer && (il = (IdentifiedLayer)layer).id().equals((Object)identifier);
    }

    @Environment(value=EnvType.CLIENT)
    @VisibleForTesting
    static interface LayerVisitor {
        public boolean visit(class_9080.class_9081 var1, ListIterator<class_9080.class_9081> var2);
    }
}

