/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_315;
import net.minecraft.class_3262;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_315.class})
public class GameOptionsMixin {
    @Shadow
    public List<String> field_1887;
    @Shadow
    @Final
    static Logger field_1834;

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void onLoad(CallbackInfo ci) {
        Path dataDir = FabricLoader.getInstance().getGameDir().resolve("data");
        if (Files.notExists(dataDir, new LinkOption[0])) {
            try {
                Files.createDirectories(dataDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                field_1834.warn("[Fabric Resource Loader] Could not create data directory: " + String.valueOf(dataDir.toAbsolutePath()));
            }
        }
        Path trackerFile = dataDir.resolve("fabricDefaultResourcePacks.dat");
        HashSet<String> trackedPacks = new HashSet<String>();
        if (Files.exists(trackerFile, new LinkOption[0])) {
            try {
                class_2487 data = class_2507.method_30613((Path)trackerFile, (class_2505)class_2505.method_53898());
                class_2499 values = data.method_10554("values", 8);
                for (int i = 0; i < values.size(); ++i) {
                    trackedPacks.add(values.method_10608(i));
                }
            }
            catch (IOException e) {
                field_1834.warn("[Fabric Resource Loader] Could not read " + String.valueOf(trackerFile.toAbsolutePath()), (Throwable)e);
            }
        }
        HashSet removedPacks = new HashSet(trackedPacks);
        LinkedHashSet<String> resourcePacks = new LinkedHashSet<String>(this.field_1887);
        ArrayList profiles = new ArrayList();
        ModResourcePackCreator.CLIENT_RESOURCE_PACK_PROVIDER.method_14453(profiles::add);
        for (Object profile : profiles) {
            if (profile.method_14463().equals("fabric")) {
                resourcePacks.add(profile.method_14463());
                continue;
            }
            class_3262 pack = profile.method_14458();
            try {
                ModNioResourcePack builtinPack;
                if (!(pack instanceof ModNioResourcePack) || !(builtinPack = (ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) continue;
                if (trackedPacks.add(builtinPack.method_14409())) {
                    resourcePacks.add(profile.method_14463());
                    continue;
                }
                removedPacks.remove(builtinPack.method_14409());
            }
            finally {
                if (pack == null) continue;
                pack.close();
            }
        }
        try {
            class_2499 values = new class_2499();
            for (String id : trackedPacks) {
                if (removedPacks.contains(id)) continue;
                values.add((Object)class_2519.method_23256((String)id));
            }
            class_2487 nbt = new class_2487();
            nbt.method_10566("values", (class_2520)values);
            class_2507.method_30614((class_2487)nbt, (Path)trackerFile);
        }
        catch (IOException e) {
            field_1834.warn("[Fabric Resource Loader] Could not write to " + String.valueOf(trackerFile.toAbsolutePath()), (Throwable)e);
        }
        this.field_1887 = new ArrayList<String>(resourcePacks);
    }
}

