/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.impl.resource.loader.ServerLanguageUtil;
import net.minecraft.class_2477;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_2477.class})
class LanguageMixin {
    @Shadow
    @Final
    private static Logger field_11490;

    LanguageMixin() {
    }

    @Redirect(method={"create"}, at=@At(value="INVOKE", target="Ljava/util/Map;copyOf(Ljava/util/Map;)Ljava/util/Map;", remap=false))
    private static Map<String, String> create(Map<String, String> map) {
        for (Path path : ServerLanguageUtil.getModLanguageFiles()) {
            LanguageMixin.loadFromPath(path, map::put);
        }
        return ImmutableMap.copyOf(map);
    }

    private static void loadFromPath(Path path, BiConsumer<String, String> entryConsumer) {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            field_11490.debug("Loading translations from {}", (Object)path);
            LanguageMixin.method_29425(stream, entryConsumer);
        }
        catch (JsonParseException | IOException e) {
            field_11490.error("Couldn't read strings from {}", (Object)path, (Object)e);
        }
    }

    @Shadow
    public static void method_29425(InputStream inputStream, BiConsumer<String, String> entryConsumer) {
    }
}

