/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.resource.loader.FabricLifecycledResourceManager;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3902;
import net.minecraft.class_4010;
import net.minecraft.class_4011;
import net.minecraft.class_4014;

@Mixin(class_4014.class)
public class SimpleResourceReloadMixin {
	@Unique
	private static final ThreadLocal<class_3264> fabric_resourceType = new ThreadLocal<>();

	@Inject(method = "start", at = @At("HEAD"))
	private static void method_40087(class_3300 resourceManager, List<class_3302> list, Executor executor, Executor executor2, CompletableFuture<class_3902> completableFuture, boolean bl, CallbackInfoReturnable<class_4011> cir) {
		if (resourceManager instanceof FabricLifecycledResourceManager flrm) {
			fabric_resourceType.set(flrm.fabric_getResourceType());
		}
	}

	@ModifyArg(method = "start", index = 1, at = @At(value = "INVOKE", target = "Lnet/minecraft/resource/SimpleResourceReload;create(Lnet/minecraft/resource/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;)Lnet/minecraft/resource/SimpleResourceReload;"))
	private static List<class_3302> sortSimple(List<class_3302> reloaders) {
		List<class_3302> sorted = ResourceManagerHelperImpl.sort(fabric_resourceType.get(), reloaders);
		fabric_resourceType.set(null);
		return sorted;
	}

	@Redirect(method = "start", at = @At(value = "NEW", target = "(Lnet/minecraft/resource/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;)Lnet/minecraft/resource/ProfiledResourceReload;"))
	private static class_4010 sortProfiled(class_3300 manager, List<class_3302> reloaders, Executor prepareExecutor, Executor applyExecutor, CompletableFuture<class_3902> initialStage) {
		List<class_3302> sorted = ResourceManagerHelperImpl.sort(fabric_resourceType.get(), reloaders);
		fabric_resourceType.set(null);
		return new class_4010(manager, sorted, prepareExecutor, applyExecutor, initialStage);
	}
}
