/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.resource;

import net.minecraft.class_2960;

/**
 * This class contains default keys for various Minecraft resource reload listeners.
 *
 * @see IdentifiableResourceReloadListener
 */
public final class ResourceReloadListenerKeys {
	// client
	public static final class_2960 SOUNDS = class_2960.method_60656("sounds");
	public static final class_2960 FONTS = class_2960.method_60656("fonts");
	public static final class_2960 MODELS = class_2960.method_60656("models");
	public static final class_2960 LANGUAGES = class_2960.method_60656("languages");
	public static final class_2960 TEXTURES = class_2960.method_60656("textures");

	// server
	public static final class_2960 RECIPES = class_2960.method_60656("recipes");
	public static final class_2960 ADVANCEMENTS = class_2960.method_60656("advancements");
	public static final class_2960 FUNCTIONS = class_2960.method_60656("functions");

	private ResourceReloadListenerKeys() { }
}
