/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import net.fabricmc.loom.bootstrap.BootstrappedPlugin;
import net.fabricmc.loom.configuration.CompileConfiguration;
import net.fabricmc.loom.configuration.FabricApiExtension;
import net.fabricmc.loom.configuration.MavenPublication;
import net.fabricmc.loom.configuration.ide.IdeConfiguration;
import net.fabricmc.loom.configuration.ide.idea.IdeaConfiguration;
import net.fabricmc.loom.decompilers.DecompilerConfiguration;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.extension.LoomGradleExtensionImpl;
import net.fabricmc.loom.task.LoomTasks;
import net.fabricmc.loom.util.LibraryLocationLogger;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginAware;

public class LoomGradlePlugin
implements BootstrappedPlugin {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final String LOOM_VERSION = Objects.requireNonNullElse(LoomGradlePlugin.class.getPackage().getImplementationVersion(), "0.0.0+unknown");

    @Override
    public void apply(PluginAware target) {
        target.getPlugins().apply(LoomRepositoryPlugin.class);
        if (target instanceof Project) {
            Project project = (Project)target;
            this.apply(project);
        }
    }

    public void apply(Project project) {
        project.getLogger().lifecycle("Fabric Loom: " + LOOM_VERSION);
        LibraryLocationLogger.logLibraryVersions();
        project.apply((Map)ImmutableMap.of((Object)"plugin", (Object)"java-library"));
        project.apply((Map)ImmutableMap.of((Object)"plugin", (Object)"eclipse"));
        project.apply((Map)ImmutableMap.of((Object)"plugin", (Object)"idea"));
        project.getExtensions().create(LoomGradleExtensionAPI.class, "loom", LoomGradleExtensionImpl.class, new Object[]{project, LoomFiles.create(project)});
        project.getExtensions().create("fabricApi", FabricApiExtension.class, new Object[]{project});
        CompileConfiguration.setupConfigurations(project);
        IdeConfiguration.setup(project);
        CompileConfiguration.configureCompile(project);
        MavenPublication.configure(project);
        LoomTasks.registerTasks(project);
        DecompilerConfiguration.setup(project);
        IdeaConfiguration.setup(project);
    }
}

