/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom;

import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.util.MirrorUtil;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginAware;
import org.jetbrains.annotations.NotNull;

public class LoomRepositoryPlugin
implements Plugin<PluginAware> {
    public void apply(@NotNull PluginAware target) {
        if (target instanceof Settings) {
            Settings settings = (Settings)target;
            this.declareRepositories(settings.getDependencyResolutionManagement().getRepositories(), LoomFiles.create(settings), (ExtensionAware)settings);
            settings.getGradle().getPluginManager().apply(LoomRepositoryPlugin.class);
        } else if (target instanceof Project) {
            Project project = (Project)target;
            if (project.getGradle().getPlugins().hasPlugin(LoomRepositoryPlugin.class)) {
                return;
            }
            this.declareRepositories(project.getRepositories(), LoomFiles.create(project), (ExtensionAware)project);
        } else {
            if (target instanceof Gradle) {
                return;
            }
            throw new IllegalArgumentException("Expected target to be a Project or Settings, but was a " + target.getClass());
        }
    }

    private void declareRepositories(RepositoryHandler repositories, LoomFiles files, ExtensionAware target) {
        repositories.maven(repo -> {
            repo.setName("UserLocalRemappedMods");
            repo.setUrl((Object)files.getRemappedModCache());
        });
        repositories.maven(repo -> {
            repo.setName("Fabric");
            repo.setUrl((Object)MirrorUtil.getFabricRepository(target));
        });
        MavenArtifactRepository mojangRepo = repositories.maven(repo -> {
            repo.setName("Mojang");
            repo.setUrl((Object)MirrorUtil.getLibrariesBase(target));
            repo.metadataSources(sources -> {
                sources.mavenPom();
                sources.artifact();
                sources.ignoreGradleMetadataRedirection();
            });
        });
        ArtifactRepository mavenCentral = (ArtifactRepository)repositories.findByName("MavenRepo");
        if (mavenCentral != null) {
            repositories.remove((Object)mojangRepo);
            repositories.add(repositories.indexOf((Object)mavenCentral), (Object)mojangRepo);
        }
        repositories.mavenCentral();
        repositories.ivy(repo -> {
            repo.setUrl((Object)files.getUserCache());
            repo.patternLayout(layout -> layout.artifact("[revision]/[artifact](-[classifier])(.[ext])"));
            repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
        });
        repositories.ivy(repo -> {
            repo.setUrl((Object)files.getRootProjectPersistentCache());
            repo.patternLayout(layout -> layout.artifact("[revision]/[artifact](-[classifier])(.[ext])"));
            repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
        });
    }

    public static void setupForLegacyVersions(Project project) {
        project.getRepositories().named("Mojang", MavenArtifactRepository.class, repo -> repo.metadataSources(sources -> {
            sources.artifact();
            sources.ignoreGradleMetadataRedirection();
        }));
    }

    public static void forceLWJGLFromMavenCentral(Project project) {
        MavenArtifactRepository central = project.getRepositories().maven(repo -> {
            repo.setName("MavenCentralLWJGL");
            repo.setUrl((Object)"https://repo.maven.apache.org/maven2/");
            repo.content(content -> content.includeGroup("org.lwjgl"));
        });
        project.getRepositories().exclusiveContent(repository -> {
            repository.forRepositories(new ArtifactRepository[]{central});
            repository.filter(filter -> filter.includeGroup("org.lwjgl"));
        });
    }
}

