/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.api;

import javax.inject.Inject;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.gradle.SourceSetReference;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.ApiStatus;

public abstract class ModSettings
implements Named {
    public abstract ConfigurableFileCollection getModFiles();

    @Inject
    public ModSettings() {
        this.getModSourceSets().finalizeValueOnRead();
        this.getModFiles().finalizeValueOnRead();
    }

    public void sourceSet(SourceSet sourceSet) {
        Project project = this.getProject();
        if (!SourceSetHelper.isSourceSetOfProject(sourceSet, project)) {
            this.getProject().getLogger().info("Computing owner project for SourceSet {} as it is not a sourceset of {}", (Object)sourceSet.getName(), (Object)project.getPath());
            project = SourceSetHelper.getSourceSetProject(sourceSet);
            if (project == this.getProject()) {
                throw new IllegalStateException("isSourceSetOfProject lied, report to loom devs.");
            }
        }
        this.sourceSet(sourceSet, project);
    }

    public void sourceSet(SourceSet sourceSet, Project project) {
        this.getModSourceSets().add((Object)new SourceSetReference(sourceSet, project));
    }

    public void dependency(Dependency ... dependencies) {
        Configuration detachedConfiguration = this.getProject().getConfigurations().detachedConfiguration(dependencies);
        this.configuration(detachedConfiguration);
    }

    public void configuration(Configuration configuration) {
        this.getModFiles().from(new Object[]{configuration});
    }

    @ApiStatus.Internal
    public abstract ListProperty<SourceSetReference> getModSourceSets();

    @Inject
    public abstract Project getProject();
}

