/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public final class MixinRefmapHelper {
    private static final String FABRIC_MOD_JSON = "fabric.mod.json";

    private MixinRefmapHelper() {
    }

    @NotNull
    public static Collection<String> getMixinConfigurationFiles(JsonObject fabricModJson) {
        JsonArray mixins = fabricModJson.getAsJsonArray("mixins");
        if (mixins == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(mixins.spliterator(), false).map(e -> {
            if (e instanceof JsonPrimitive) {
                JsonPrimitive str = (JsonPrimitive)e;
                return str.getAsString();
            }
            if (e instanceof JsonObject) {
                JsonObject obj = (JsonObject)e;
                return obj.get("config").getAsString();
            }
            throw new RuntimeException("Incorrect fabric.mod.json format");
        }).collect(Collectors.toSet());
    }
}

