/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build.nesting;

import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.util.ModUtils;
import net.fabricmc.loom.util.ZipUtils;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.Nullable;

public final class IncludedJarFactory {
    private final Project project;

    public IncludedJarFactory(Project project) {
        this.project = project;
    }

    public Provider<ConfigurableFileCollection> getNestedJars(Configuration configuration) {
        return this.project.provider(() -> {
            ConfigurableFileCollection files = this.project.files(new Object[0]);
            HashSet visited = Sets.newHashSet();
            files.from(new Object[]{this.getProjectDeps(configuration, visited)});
            files.from(new Object[]{this.getFileDeps(configuration, visited)});
            files.builtBy(new Object[]{configuration.getBuildDependencies()});
            return files;
        });
    }

    private ConfigurableFileCollection getFileDeps(Configuration configuration, Set<String> visited) {
        ConfigurableFileCollection files = this.project.files(new Object[0]);
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        Set dependencies = resolvedConfiguration.getFirstLevelModuleDependencies();
        for (ResolvedDependency dependency : dependencies) {
            if (!visited.add(dependency.getModuleGroup() + ":" + dependency.getModuleName() + ":" + dependency.getModuleVersion())) continue;
            for (ResolvedArtifact artifact : dependency.getModuleArtifacts()) {
                Metadata metadata = new Metadata(dependency.getModuleGroup(), dependency.getModuleName(), dependency.getModuleVersion(), artifact.getClassifier());
                files.from(new Object[]{this.project.provider(() -> this.getNestableJar(artifact.getFile(), metadata))});
            }
        }
        return files;
    }

    private ConfigurableFileCollection getProjectDeps(Configuration configuration, Set<String> visited) {
        ConfigurableFileCollection files = this.project.files(new Object[0]);
        for (Dependency dependency : configuration.getDependencies()) {
            if (!(dependency instanceof ProjectDependency)) continue;
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            if (!visited.add(dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion())) continue;
            Project dependentProject = projectDependency.getDependencyProject();
            Set remapJarTasks = dependentProject.getTasksByName("remapJar", false);
            Set jarTasks = dependentProject.getTasksByName("jar", false);
            if (remapJarTasks.isEmpty() && jarTasks.isEmpty()) {
                throw new UnsupportedOperationException("%s does not have a remapJar or jar task, cannot nest it".formatted(dependentProject.getName()));
            }
            for (Task task : remapJarTasks.isEmpty() ? jarTasks : remapJarTasks) {
                if (task instanceof AbstractArchiveTask) {
                    AbstractArchiveTask archiveTask = (AbstractArchiveTask)task;
                    Metadata metadata = new Metadata(projectDependency.getGroup(), projectDependency.getName(), projectDependency.getVersion(), (String)archiveTask.getArchiveClassifier().getOrNull());
                    Provider provider = archiveTask.getArchiveFile().map(regularFile -> this.getNestableJar(regularFile.getAsFile(), metadata));
                    files.from(new Object[]{provider});
                    files.builtBy(new Object[]{task});
                    continue;
                }
                throw new UnsupportedOperationException("Cannot nest none AbstractArchiveTask task: " + task.getName());
            }
        }
        return files;
    }

    private File getNestableJar(File input, Metadata metadata) {
        File tempFile;
        if (ModUtils.isMod(input)) {
            return input;
        }
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        File tempDir = new File(extension.getFiles().getUserCache(), "temp/modprocessing");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        if ((tempFile = new File(tempDir, input.getName())).exists()) {
            tempFile.delete();
        }
        try {
            FileUtils.copyFile((File)input, (File)tempFile);
            ZipUtils.add(tempFile.toPath(), "fabric.mod.json", IncludedJarFactory.generateModForDependency(metadata).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to add dummy mod while including %s".formatted(input), e);
        }
        return tempFile;
    }

    private static String generateModForDependency(Metadata metadata) {
        Object modId = (metadata.group() + "_" + metadata.name() + metadata.classifier()).replaceAll("\\.", "_").toLowerCase(Locale.ENGLISH);
        if (((String)modId).length() > 64) {
            String hash = Hashing.sha256().hashString((CharSequence)modId, StandardCharsets.UTF_8).toString();
            modId = ((String)modId).substring(0, 50) + hash.substring(0, 14);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("schemaVersion", (Number)1);
        jsonObject.addProperty("id", (String)modId);
        jsonObject.addProperty("version", metadata.version());
        jsonObject.addProperty("name", metadata.name());
        JsonObject custom = new JsonObject();
        custom.addProperty("fabric-loom:generated", Boolean.valueOf(true));
        jsonObject.add("custom", (JsonElement)custom);
        return LoomGradlePlugin.GSON.toJson((JsonElement)jsonObject);
    }

    private record Metadata(String group, String name, String version, @Nullable String classifier) {
        @Nullable
        private final String classifier;

        public String classifier() {
            if (this.classifier == null) {
                return "";
            }
            return "_" + this.classifier;
        }
    }
}

