/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.mixin.GroovyApInvoker;
import net.fabricmc.loom.build.mixin.JavaApInvoker;
import net.fabricmc.loom.build.mixin.KaptApInvoker;
import net.fabricmc.loom.build.mixin.ScalaApInvoker;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.LoomDependencyManager;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerJarProcessor;
import net.fabricmc.loom.configuration.accesswidener.TransitiveAccessWidenerJarProcessor;
import net.fabricmc.loom.configuration.ifaceinject.InterfaceInjectionProcessor;
import net.fabricmc.loom.configuration.processors.JarProcessorManager;
import net.fabricmc.loom.configuration.processors.ModJavadocProcessor;
import net.fabricmc.loom.configuration.providers.mappings.MappingsProviderImpl;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.IntermediaryMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;

public final class CompileConfiguration {
    private CompileConfiguration() {
    }

    public static void setupConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        configurations.register("modCompileClasspath", configuration -> configuration.setTransitive(true));
        configurations.register("modCompileClasspathMapped", configuration -> configuration.setTransitive(false));
        NamedDomainObjectProvider serverDeps = configurations.register("minecraftServerLibraries", configuration -> configuration.setTransitive(false));
        configurations.register("minecraftRuntimeOnlyLibraries", configuration -> configuration.setTransitive(false));
        configurations.register("minecraftLibraries", configuration -> {
            configuration.extendsFrom(new Configuration[]{(Configuration)serverDeps.get()});
            configuration.setTransitive(false);
        });
        configurations.register("loaderLibraries", configuration -> configuration.setTransitive(false));
        configurations.register("minecraft", configuration -> configuration.setTransitive(false));
        configurations.register("include", configuration -> configuration.setTransitive(false));
        configurations.register("mappingsConstants");
        configurations.register("namedElements", configuration -> {
            configuration.setCanBeConsumed(true);
            configuration.setCanBeResolved(false);
            configuration.extendsFrom(new Configuration[]{configurations.getByName("api")});
        });
        CompileConfiguration.extendsFrom("compileOnly", "mappingsConstants", project);
        configurations.register("mappings");
        configurations.register("mappingsFinal");
        configurations.register("loomDevelopmentDependencies");
        configurations.register("unpick");
        configurations.register("localRuntime");
        CompileConfiguration.extendsFrom("runtimeClasspath", "localRuntime", project);
        extension.createRemapConfigurations(SourceSetHelper.getMainSourceSet(project));
        CompileConfiguration.extendsFrom("loaderLibraries", "minecraftLibraries", project);
        CompileConfiguration.extendsFrom("runtimeClasspath", "mappingsFinal", project);
        CompileConfiguration.extendsFrom("testRuntimeClasspath", "mappingsFinal", project);
        CompileConfiguration.extendsFrom("runtimeClasspath", "loomDevelopmentDependencies", project);
        CompileConfiguration.extendsFrom("testRuntimeClasspath", "loomDevelopmentDependencies", project);
        CompileConfiguration.extendsFrom("runtimeClasspath", "minecraftRuntimeOnlyLibraries", project);
        project.getDependencies().add("loomDevelopmentDependencies", (Object)"net.fabricmc:dev-launch-injector:0.2.1+build.8");
        project.getDependencies().add("loomDevelopmentDependencies", (Object)"net.minecrell:terminalconsoleappender:1.2.0");
        project.getDependencies().add("compileOnly", (Object)"org.jetbrains:annotations:23.0.0");
        project.getDependencies().add("testCompileOnly", (Object)"org.jetbrains:annotations:23.0.0");
    }

    public static void configureCompile(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        project.getTasks().named("javadoc", Javadoc.class).configure(javadoc -> {
            SourceSet main = SourceSetHelper.getMainSourceSet(project);
            javadoc.setClasspath(main.getOutput().plus(main.getCompileClasspath()));
        });
        GradleUtils.afterSuccessfulEvaluation(project, () -> {
            MinecraftSourceSets.get(project).afterEvaluate(project);
            boolean previousRefreshDeps = extension.refreshDeps();
            if (CompileConfiguration.getAndLock(project)) {
                project.getLogger().lifecycle("Found existing cache lock file, rebuilding loom cache. This may have been caused by a failed or canceled build.");
                extension.setRefreshDeps(true);
            }
            try {
                CompileConfiguration.setupMinecraft(project);
            }
            catch (Exception e) {
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to setup Minecraft", e);
            }
            LoomDependencyManager dependencyManager = new LoomDependencyManager();
            extension.setDependencyManager(dependencyManager);
            dependencyManager.handleDependencies(project);
            CompileConfiguration.releaseLock(project);
            extension.setRefreshDeps(previousRefreshDeps);
            MixinExtension mixin = LoomGradleExtension.get(project).getMixin();
            if (((Boolean)mixin.getUseLegacyMixinAp().get()).booleanValue()) {
                CompileConfiguration.setupMixinAp(project, mixin);
            }
            CompileConfiguration.configureDecompileTasks(project);
        });
        CompileConfiguration.finalizedBy(project, "idea", "genIdeaWorkspace");
        CompileConfiguration.finalizedBy(project, "eclipse", "genEclipseRuns");
        CompileConfiguration.finalizedBy(project, "cleanEclipse", "cleanEclipseRuns");
        project.artifacts(artifactHandler -> artifactHandler.add("namedElements", (Object)project.getTasks().named("jar")));
        project.getTasks().withType(AbstractCopyTask.class).configureEach(abstractCopyTask -> abstractCopyTask.setFilteringCharset(StandardCharsets.UTF_8.name()));
        project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> javaCompile.getOptions().setEncoding(StandardCharsets.UTF_8.name()));
        if (project.getPluginManager().hasPlugin("org.jetbrains.kotlin.kapt")) {
            throw new IllegalArgumentException("fabric-loom must be applied BEFORE kapt in the plugins { } block.");
        }
    }

    private static synchronized void setupMinecraft(Project project) throws Exception {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        MinecraftJarConfiguration jarConfiguration = (MinecraftJarConfiguration)((Object)extension.getMinecraftJarConfiguration().get());
        MinecraftProvider minecraftProvider = jarConfiguration.getMinecraftProviderFunction().apply(project);
        extension.setMinecraftProvider(minecraftProvider);
        minecraftProvider.provide();
        DependencyInfo mappingsDep = DependencyInfo.create(project, "mappings");
        MappingsProviderImpl mappingsProvider = MappingsProviderImpl.getInstance(project, mappingsDep, minecraftProvider);
        extension.setMappingsProvider(mappingsProvider);
        mappingsProvider.applyToProject(project, mappingsDep);
        IntermediaryMinecraftProvider<?> intermediaryMinecraftProvider = jarConfiguration.getIntermediaryMinecraftProviderBiFunction().apply(project, minecraftProvider);
        NamedMinecraftProvider namedMinecraftProvider = jarConfiguration.getNamedMinecraftProviderBiFunction().apply(project, minecraftProvider);
        JarProcessorManager jarProcessorManager = CompileConfiguration.createJarProcessorManager(project);
        if (jarProcessorManager.active()) {
            namedMinecraftProvider = jarConfiguration.getProcessedNamedMinecraftProviderBiFunction().apply(namedMinecraftProvider, jarProcessorManager);
        }
        extension.setIntermediaryMinecraftProvider(intermediaryMinecraftProvider);
        intermediaryMinecraftProvider.provide(true);
        extension.setNamedMinecraftProvider(namedMinecraftProvider);
        namedMinecraftProvider.provide(true);
    }

    private static JarProcessorManager createJarProcessorManager(Project project) {
        ModJavadocProcessor javadocProcessor;
        InterfaceInjectionProcessor jarProcessor;
        TransitiveAccessWidenerJarProcessor transitiveAccessWidenerJarProcessor;
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.getAccessWidenerPath().isPresent()) {
            extension.getGameJarProcessors().add((Object)new AccessWidenerJarProcessor(project));
        }
        if (((Boolean)extension.getEnableTransitiveAccessWideners().get()).booleanValue() && !(transitiveAccessWidenerJarProcessor = new TransitiveAccessWidenerJarProcessor(project)).isEmpty()) {
            extension.getGameJarProcessors().add((Object)transitiveAccessWidenerJarProcessor);
        }
        if (extension.getInterfaceInjection().isEnabled() && !(jarProcessor = new InterfaceInjectionProcessor(project)).isEmpty()) {
            extension.getGameJarProcessors().add((Object)jarProcessor);
        }
        if (((Boolean)extension.getEnableModProvidedJavadoc().get()).booleanValue() && (javadocProcessor = ModJavadocProcessor.create(project)) != null) {
            extension.getGameJarProcessors().add((Object)javadocProcessor);
        }
        JarProcessorManager processorManager = new JarProcessorManager((List)extension.getGameJarProcessors().get());
        extension.setJarProcessorManager(processorManager);
        processorManager.setupProcessors();
        return processorManager;
    }

    private static void setupMixinAp(Project project, MixinExtension mixin) {
        mixin.init();
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("log4j.shutdownHookEnabled", "false");
        System.setProperty("log4j.skipJansi", "true");
        project.getLogger().info("Configuring compiler arguments for Java");
        new JavaApInvoker(project).configureMixin();
        if (project.getPluginManager().hasPlugin("scala")) {
            project.getLogger().info("Configuring compiler arguments for Scala");
            new ScalaApInvoker(project).configureMixin();
        }
        if (project.getPluginManager().hasPlugin("org.jetbrains.kotlin.kapt")) {
            project.getLogger().info("Configuring compiler arguments for Kapt plugin");
            new KaptApInvoker(project).configureMixin();
        }
        if (project.getPluginManager().hasPlugin("groovy")) {
            project.getLogger().info("Configuring compiler arguments for Groovy");
            new GroovyApInvoker(project).configureMixin();
        }
    }

    private static void configureDecompileTasks(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ((MinecraftJarConfiguration)((Object)extension.getMinecraftJarConfiguration().get())).getDecompileConfigurationBiFunction().apply(project, extension.getNamedMinecraftProvider()).afterEvaluation();
    }

    private static Path getLockFile(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Path cacheDirectory = extension.getFiles().getUserCache().toPath();
        String pathHash = Checksum.toHex(project.getProjectDir().getAbsolutePath().getBytes(StandardCharsets.UTF_8)).substring(0, 16);
        return cacheDirectory.resolve("." + pathHash + ".lock");
    }

    private static boolean getAndLock(Project project) {
        Path lock = CompileConfiguration.getLockFile(project);
        if (Files.exists(lock, new LinkOption[0])) {
            return true;
        }
        try {
            Files.createFile(lock, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to acquire project configuration lock", e);
        }
        return false;
    }

    private static void releaseLock(Project project) {
        Path lock = CompileConfiguration.getLockFile(project);
        if (!Files.exists(lock, new LinkOption[0])) {
            return;
        }
        try {
            Files.delete(lock);
        }
        catch (IOException e1) {
            try {
                Path del = lock.resolveSibling(lock.getFileName() + ".del");
                Files.move(lock, del, new CopyOption[0]);
                Files.delete(del);
            }
            catch (IOException e2) {
                UncheckedIOException exception = new UncheckedIOException("Failed to release project configuration lock", e2);
                exception.addSuppressed(e1);
                throw exception;
            }
        }
    }

    public static void extendsFrom(List<String> parents, String b, Project project) {
        for (String parent : parents) {
            CompileConfiguration.extendsFrom(parent, b, project);
        }
    }

    public static void extendsFrom(String a, String b, Project project) {
        project.getConfigurations().getByName(a, configuration -> configuration.extendsFrom(new Configuration[]{project.getConfigurations().getByName(b)}));
    }

    private static void finalizedBy(Project project, String a, String b) {
        project.getTasks().named(a).configure(task -> task.finalizedBy(new Object[]{project.getTasks().named(b)}));
    }
}

