/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import com.google.gson.JsonObject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import net.fabricmc.loom.configuration.mods.ModConfigurationRemapper;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public class LoomDependencyManager {
    public void handleDependencies(Project project) {
        ArrayList afterTasks = new ArrayList();
        project.getLogger().info(":setting up loom dependencies");
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.getInstallerData() == null) {
            project.getLogger().info("Searching through modCompileClasspath for installer JSON");
            Configuration configuration = project.getConfigurations().getByName("modCompileClasspath");
            for (Dependency dependency : configuration.getAllDependencies()) {
                for (File input : configuration.files(new Dependency[]{dependency})) {
                    JsonObject jsonObject = LoomDependencyManager.readInstallerJson(input);
                    if (jsonObject == null) continue;
                    if (extension.getInstallerData() != null) {
                        project.getLogger().info("Found another installer JSON in, ignoring it! " + input);
                        continue;
                    }
                    project.getLogger().info("Found installer JSON in " + input);
                    extension.setInstallerData(new InstallerData(dependency.getVersion(), jsonObject));
                    LoomDependencyManager.handleInstallerJson(jsonObject, project);
                }
            }
        }
        SourceRemapper sourceRemapper = new SourceRemapper(project, true);
        String mappingsIdentifier = extension.getMappingsProvider().mappingsIdentifier();
        ModConfigurationRemapper.supplyModConfigurations(project, mappingsIdentifier, extension, sourceRemapper);
        sourceRemapper.remapAll();
        if (extension.getInstallerData() == null) {
            project.getLogger().warn("fabric-installer.json not found in classpath!");
        }
        for (Runnable runnable : afterTasks) {
            runnable.run();
        }
    }

    public static JsonObject readInstallerJson(File file) {
        try {
            byte[] bytes = ZipUtils.unpackNullable(file.toPath(), "fabric-installer.json");
            if (bytes == null) {
                return null;
            }
            return (JsonObject)LoomGradlePlugin.GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), JsonObject.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to try and read installer json from " + file, e);
        }
    }

    private static void handleInstallerJson(JsonObject jsonObject, Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        JsonObject libraries = jsonObject.get("libraries").getAsJsonObject();
        Configuration loaderDepsConfig = project.getConfigurations().getByName("loaderLibraries");
        Configuration apDepsConfig = project.getConfigurations().getByName("annotationProcessor");
        libraries.get("common").getAsJsonArray().forEach(jsonElement -> {
            String name = jsonElement.getAsJsonObject().get("name").getAsString();
            ExternalModuleDependency modDep = (ExternalModuleDependency)project.getDependencies().create((Object)name);
            modDep.setTransitive(false);
            loaderDepsConfig.getDependencies().add((Object)modDep);
            if (!IdeaUtils.isIdeaSync() && ((Boolean)extension.getMixin().getUseLegacyMixinAp().get()).booleanValue()) {
                apDepsConfig.getDependencies().add((Object)modDep);
            }
            project.getLogger().debug("Loom adding " + name + " from installer JSON");
            if (jsonElement.getAsJsonObject().has("url") && !project.getGradle().getPlugins().hasPlugin(LoomRepositoryPlugin.class)) {
                String url = jsonElement.getAsJsonObject().get("url").getAsString();
                long count = project.getRepositories().stream().filter(artifactRepository -> artifactRepository instanceof MavenArtifactRepository).map(artifactRepository -> (MavenArtifactRepository)artifactRepository).filter(mavenArtifactRepository -> mavenArtifactRepository.getUrl().toString().equalsIgnoreCase(url)).count();
                if (count == 0L) {
                    project.getRepositories().maven(mavenArtifactRepository -> mavenArtifactRepository.setUrl((Object)jsonElement.getAsJsonObject().get("url").getAsString()));
                }
            }
        });
    }
}

