/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerTransformer;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;

public class AccessWidenerJarProcessor
implements JarProcessor {
    private static final String HASH_FILENAME = "aw.sha256";
    private byte[] modAccessWidener;
    private final AccessWidener accessWidener = new AccessWidener();
    private final Project project;
    private byte[] inputHash;

    public AccessWidenerJarProcessor(Project project) {
        this.project = project;
    }

    @Override
    public String getId() {
        return "loom:access_widener:" + Checksum.toHex(this.inputHash);
    }

    @Override
    public void setup() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        Path awPath = ((RegularFile)extension.getAccessWidenerPath().get()).getAsFile().toPath();
        try {
            this.modAccessWidener = Files.readAllBytes(awPath);
        }
        catch (NoSuchFileException e) {
            throw new RuntimeException("Could not find access widener file @ " + awPath.toAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read access widener: " + awPath);
        }
        AccessWidenerReader reader = new AccessWidenerReader((AccessWidenerVisitor)this.accessWidener);
        reader.read(this.modAccessWidener);
        this.inputHash = Hashing.sha256().hashBytes(this.modAccessWidener).asBytes();
    }

    @Override
    public void process(File file) {
        AccessWidenerTransformer applier = new AccessWidenerTransformer(this.project.getLogger(), this.accessWidener);
        applier.apply(file);
        try {
            ZipUtils.add(file.toPath(), HASH_FILENAME, this.inputHash);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write aw jar hash", e);
        }
    }
}

