/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.AccessWidenerClassVisitor;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

final class AccessWidenerTransformer {
    private final Logger logger;
    private final AccessWidener accessWidener;

    AccessWidenerTransformer(Logger logger, AccessWidener accessWidener) {
        this.logger = logger;
        this.accessWidener = accessWidener;
    }

    void apply(File jarFile) {
        try {
            ZipUtils.transform(jarFile.toPath(), this.getTransformers(this.accessWidener.getTargets()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to apply access wideners to %s".formatted(jarFile), e);
        }
    }

    private List<Pair<String, ZipUtils.UnsafeUnaryOperator<byte[]>>> getTransformers(Set<String> classes) {
        return classes.stream().map(string -> new Pair<CallSite, ZipUtils.UnsafeUnaryOperator<byte[]>>((CallSite)((Object)(string.replaceAll("\\.", "/") + ".class")), this.getTransformer((String)string))).collect(Collectors.toList());
    }

    private ZipUtils.UnsafeUnaryOperator<byte[]> getTransformer(String className) {
        return input -> {
            ClassReader reader = new ClassReader(input);
            ClassWriter writer = new ClassWriter(0);
            ClassVisitor classVisitor = AccessWidenerClassVisitor.createClassVisitor((int)589824, (ClassVisitor)writer, (AccessWidener)this.accessWidener);
            this.logger.info("Applying access widener to " + className);
            reader.accept(classVisitor, 0);
            return writer.toByteArray();
        };
    }
}

