/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerRemapper;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.accesswidener.TransitiveOnlyFilter;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerFile;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerTransformer;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileCollection;
import org.objectweb.asm.commons.Remapper;

public class TransitiveAccessWidenerJarProcessor
implements JarProcessor {
    private final Project project;
    private final LoomGradleExtension extension;
    private final List<AccessWidenerFile> transitiveAccessWideners;

    public TransitiveAccessWidenerJarProcessor(Project project) {
        this.project = project;
        this.extension = LoomGradleExtension.get(project);
        this.transitiveAccessWideners = this.getTransitiveAccessWideners();
        this.extension.addTransitiveAccessWideners(this.transitiveAccessWideners);
    }

    @Override
    public void setup() {
    }

    public boolean isEmpty() {
        return this.transitiveAccessWideners.isEmpty();
    }

    @Override
    public String getId() {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0);
        return "loom:transitive_access_wideners:" + this.transitiveAccessWideners.hashCode();
    }

    private List<AccessWidenerFile> getTransitiveAccessWideners() {
        ArrayList<AccessWidenerFile> accessWideners = new ArrayList<AccessWidenerFile>();
        HashSet<Path> possibleModJars = new HashSet<Path>();
        for (RemapConfigurationSettings entry : this.extension.getCompileRemapConfigurations()) {
            Configuration configuration = (Configuration)entry.getSourceConfiguration().get();
            for (ResolvedArtifact artifact : configuration.getResolvedConfiguration().getResolvedArtifacts()) {
                possibleModJars.add(artifact.getFile().toPath());
            }
            for (FileCollectionDependency dependency : configuration.getAllDependencies().withType(FileCollectionDependency.class)) {
                FileCollection files = dependency.getFiles();
                for (File artifact : files) {
                    possibleModJars.add(artifact.toPath());
                }
            }
        }
        for (Path path : possibleModJars) {
            if (!Files.exists(path, new LinkOption[0])) {
                this.project.getLogger().debug("Could not find transitive access widener in {} as it does not exist", (Object)path.toAbsolutePath());
                continue;
            }
            AccessWidenerFile accessWidener = AccessWidenerFile.fromModJar(path);
            if (accessWidener == null || !TransitiveDetectorVisitor.isTransitive(accessWidener.content())) continue;
            accessWideners.add(accessWidener);
        }
        return accessWideners;
    }

    @Override
    public void process(File file) {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0);
        AccessWidener accessWidener = this.createAccessWidener();
        AccessWidenerTransformer transformer = new AccessWidenerTransformer(this.project.getLogger(), accessWidener);
        transformer.apply(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessWidener createAccessWidener() {
        AccessWidener accessWidener = new AccessWidener();
        TinyRemapper tinyRemapper = this.createTinyRemapper();
        try {
            AccessWidenerRemapper remappingVisitor = new AccessWidenerRemapper((AccessWidenerVisitor)accessWidener, (Remapper)tinyRemapper.getEnvironment().getRemapper(), MappingsNamespace.INTERMEDIARY.toString(), MappingsNamespace.NAMED.toString());
            AccessWidenerReader transitiveReader = new AccessWidenerReader((AccessWidenerVisitor)new TransitiveOnlyFilter((AccessWidenerVisitor)remappingVisitor));
            for (AccessWidenerFile accessWidenerFile : this.transitiveAccessWideners) {
                this.project.getLogger().info("Reading transitive access widener from {}", (Object)accessWidenerFile.modId());
                transitiveReader.read(accessWidenerFile.content());
            }
        }
        finally {
            tinyRemapper.finish();
        }
        return accessWidener;
    }

    private TinyRemapper createTinyRemapper() {
        try {
            TinyRemapper tinyRemapper = TinyRemapperHelper.getTinyRemapper(this.project, "intermediary", "named");
            tinyRemapper.readClassPath(TinyRemapperHelper.getMinecraftDependencies(this.project));
            for (Path minecraftJar : this.extension.getMinecraftJars(MappingsNamespace.INTERMEDIARY)) {
                tinyRemapper.readClassPath(new Path[]{minecraftJar});
            }
            return tinyRemapper;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create tiny remapper for intermediary->named", e);
        }
    }

    private static class TransitiveDetectorVisitor
    implements AccessWidenerVisitor {
        private boolean transitive = false;

        private TransitiveDetectorVisitor() {
        }

        public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
            if (transitive) {
                this.transitive = true;
            }
        }

        public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            if (transitive) {
                this.transitive = true;
            }
        }

        public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            if (transitive) {
                this.transitive = true;
            }
        }

        public static boolean isTransitive(byte[] content) {
            if (AccessWidenerReader.readVersion((byte[])content) < 2) {
                return false;
            }
            TransitiveDetectorVisitor transitiveDetector = new TransitiveDetectorVisitor();
            new AccessWidenerReader((AccessWidenerVisitor)transitiveDetector).read(content);
            return transitiveDetector.transitive;
        }
    }
}

