/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.util.List;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.accesswidener.TransitiveOnlyFilter;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerFile;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public record TransitiveAccessWidenerMappingsProcessor(Project project) implements GenerateSourcesTask.MappingsProcessor
{
    @Override
    public boolean transform(MemoryMappingTree mappings) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        List<AccessWidenerFile> accessWideners = extension.getTransitiveAccessWideners();
        if (accessWideners.isEmpty()) {
            return false;
        }
        if (!MappingsNamespace.INTERMEDIARY.toString().equals(mappings.getSrcNamespace())) {
            throw new IllegalStateException("Mapping tree must have intermediary src mappings not " + mappings.getSrcNamespace());
        }
        for (AccessWidenerFile accessWidener : accessWideners) {
            MappingCommentVisitor mappingCommentVisitor = new MappingCommentVisitor(accessWidener.modId(), mappings, this.project.getLogger());
            AccessWidenerReader accessWidenerReader = new AccessWidenerReader((AccessWidenerVisitor)new TransitiveOnlyFilter((AccessWidenerVisitor)mappingCommentVisitor));
            accessWidenerReader.read(accessWidener.content());
        }
        return true;
    }

    private record MappingCommentVisitor(String modId, MemoryMappingTree mappingTree, Logger logger) implements AccessWidenerVisitor
    {
        public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
            MemoryMappingTree.ClassEntry classMapping = this.mappingTree.getClass(name);
            if (classMapping == null) {
                this.logger.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)name, (Object)this.modId());
                return;
            }
            classMapping.setComment(this.appendComment(classMapping.getComment(), access));
        }

        public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            this.visitClass(owner, access, transitive);
            MemoryMappingTree.ClassEntry classMapping = this.mappingTree.getClass(owner);
            if (classMapping == null) {
                this.logger.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)owner, (Object)this.modId());
                return;
            }
            MappingTree.MethodMapping methodMapping = classMapping.getMethod(name, descriptor);
            if (methodMapping == null) {
                this.logger.info("Failed to find method ({}) in ({}) to mark access widened by mod ({})", new Object[]{name, owner, this.modId()});
                return;
            }
            methodMapping.setComment(this.appendComment(methodMapping.getComment(), access));
        }

        public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            this.visitClass(owner, access, transitive);
            MemoryMappingTree.ClassEntry classMapping = this.mappingTree.getClass(owner);
            if (classMapping == null) {
                this.logger.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)name, (Object)this.modId());
                return;
            }
            MappingTree.FieldMapping fieldMapping = classMapping.getField(name, descriptor);
            if (fieldMapping == null) {
                this.logger.info("Failed to find field ({}) in ({}) to mark access widened by mod ({})", new Object[]{name, owner, this.modId()});
                return;
            }
            fieldMapping.setComment(this.appendComment(fieldMapping.getComment(), access));
        }

        private String appendComment(String comment, AccessWidenerReader.AccessType access) {
            String awComment;
            if (!((String)(comment = comment == null ? "" : (String)comment + "\n")).contains(awComment = "Access widened by %s to %s".formatted(this.modId(), access))) {
                comment = (String)comment + awComment;
            }
            return comment;
        }
    }
}

