/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.decompile;

import java.io.File;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.mappings.MappingsProviderImpl;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.UnpickJarTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;

public abstract class DecompileConfiguration<T extends MappedMinecraftProvider> {
    protected final Project project;
    protected final T minecraftProvider;
    protected final LoomGradleExtension extension;
    protected final MappingsProviderImpl mappingsProvider;

    public DecompileConfiguration(Project project, T minecraftProvider) {
        this.project = project;
        this.minecraftProvider = minecraftProvider;
        this.extension = LoomGradleExtension.get(project);
        this.mappingsProvider = this.extension.getMappingsProvider();
    }

    public abstract void afterEvaluation();

    protected final TaskProvider<UnpickJarTask> createUnpickJarTask(String name, File inputJar, File outputJar) {
        return this.project.getTasks().register(name, UnpickJarTask.class, unpickJarTask -> {
            unpickJarTask.getUnpickDefinitions().set(this.mappingsProvider.getUnpickDefinitionsFile());
            unpickJarTask.getInputJar().set(inputJar);
            unpickJarTask.getOutputJar().set(outputJar);
        });
    }
}

