/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide.idea;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.ide.idea.IdeaSyncTask;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import net.fabricmc.loom.task.LoomTasks;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.DefaultTaskExecutionRequest;

public class IdeaConfiguration {
    public static void setup(Project project) {
        TaskProvider ideaSyncTask = project.getTasks().register("ideaSyncTask", IdeaSyncTask.class, task -> {
            if (LoomGradleExtension.get(project).getRunConfigs().stream().anyMatch(RunConfigSettings::isIdeConfigGenerated)) {
                task.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(project)});
            } else {
                task.setEnabled(false);
            }
        });
        if (!IdeaUtils.isIdeaSync()) {
            return;
        }
        StartParameter startParameter = project.getGradle().getStartParameter();
        ArrayList<DefaultTaskExecutionRequest> taskRequests = new ArrayList<DefaultTaskExecutionRequest>(startParameter.getTaskRequests());
        taskRequests.add(new DefaultTaskExecutionRequest(List.of("ideaSyncTask")));
        startParameter.setTaskRequests(taskRequests);
    }
}

